/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.sink;

import org.apache.flink.connector.hbase.sink.HBaseMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseSerde;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.hadoop.hbase.client.Mutation;

public class RowDataToMutationConverter
implements HBaseMutationConverter<RowData> {
    private static final long serialVersionUID = 1L;
    private final HBaseTableSchema schema;
    private final String nullStringLiteral;
    private transient HBaseSerde serde;

    public RowDataToMutationConverter(HBaseTableSchema schema, String nullStringLiteral) {
        this.schema = schema;
        this.nullStringLiteral = nullStringLiteral;
    }

    @Override
    public void open() {
        this.serde = new HBaseSerde(this.schema, this.nullStringLiteral);
    }

    @Override
    public Mutation convertToMutation(RowData record) {
        RowKind kind = record.getRowKind();
        if (kind == RowKind.INSERT || kind == RowKind.UPDATE_AFTER) {
            return this.serde.createPutMutation(record);
        }
        return this.serde.createDeleteMutation(record);
    }
}

