/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import org.apache.flink.annotation.Experimental;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.hbase.source.AbstractTableInputFormat;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;

@Experimental
public abstract class HBaseInputFormat<T extends Tuple>
extends AbstractTableInputFormat<T> {
    private static final long serialVersionUID = 1L;

    public HBaseInputFormat(org.apache.hadoop.conf.Configuration hConf) {
        super(hConf);
    }

    @Override
    protected abstract Scan getScanner();

    @Override
    protected abstract String getTableName();

    protected abstract T mapResultToTuple(Result var1);

    @Override
    public void configure(Configuration parameters) {
        this.table = this.createTable();
        if (this.table != null) {
            this.scan = this.getScanner();
        }
    }

    private HTable createTable() {
        LOG.info("Initializing HBaseConfiguration");
        org.apache.hadoop.conf.Configuration hConf = this.getHadoopConfiguration();
        try {
            return new HTable(hConf, this.getTableName());
        }
        catch (Exception e) {
            LOG.error("Error instantiating a new HTable instance", (Throwable)e);
            return null;
        }
    }

    @Override
    protected T mapResultToOutType(Result r) {
        return this.mapResultToTuple(r);
    }
}

