/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.sink;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.hbase.options.HBaseOptions;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.sink.HBaseSinkFunction;
import org.apache.flink.connector.hbase.sink.RowDataToMutationConverter;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

@Internal
public class HBaseDynamicTableSink
implements DynamicTableSink {
    private final HBaseTableSchema hbaseTableSchema;
    private final HBaseOptions hbaseOptions;
    private final HBaseWriteOptions writeOptions;
    private final String nullStringLiteral;

    public HBaseDynamicTableSink(HBaseTableSchema hbaseTableSchema, HBaseOptions hbaseOptions, HBaseWriteOptions writeOptions, String nullStringLiteral) {
        this.hbaseTableSchema = hbaseTableSchema;
        this.hbaseOptions = hbaseOptions;
        this.writeOptions = writeOptions;
        this.nullStringLiteral = nullStringLiteral;
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        Configuration hbaseClientConf = HBaseConfiguration.create();
        hbaseClientConf.set("hbase.zookeeper.quorum", this.hbaseOptions.getZkQuorum());
        this.hbaseOptions.getZkNodeParent().ifPresent(v -> hbaseClientConf.set("zookeeper.znode.parent", v));
        HBaseSinkFunction<RowData> sinkFunction = new HBaseSinkFunction<RowData>(this.hbaseOptions.getTableName(), hbaseClientConf, new RowDataToMutationConverter(this.hbaseTableSchema, this.nullStringLiteral), this.writeOptions.getBufferFlushMaxSizeInBytes(), this.writeOptions.getBufferFlushMaxRows(), this.writeOptions.getBufferFlushIntervalMillis());
        return SinkFunctionProvider.of(sinkFunction);
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public DynamicTableSink copy() {
        return new HBaseDynamicTableSink(this.hbaseTableSchema, this.hbaseOptions, this.writeOptions, this.nullStringLiteral);
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseTableSchema;
    }

    @VisibleForTesting
    public HBaseOptions getHBaseOptions() {
        return this.hbaseOptions;
    }

    @VisibleForTesting
    public HBaseWriteOptions getWriteOptions() {
        return this.writeOptions;
    }
}

