/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.options;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Internal;

@Internal
public class HBaseWriteOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long bufferFlushMaxSizeInBytes;
    private final long bufferFlushMaxRows;
    private final long bufferFlushIntervalMillis;

    private HBaseWriteOptions(long bufferFlushMaxSizeInBytes, long bufferFlushMaxMutations, long bufferFlushIntervalMillis) {
        this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
        this.bufferFlushMaxRows = bufferFlushMaxMutations;
        this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
    }

    public long getBufferFlushMaxSizeInBytes() {
        return this.bufferFlushMaxSizeInBytes;
    }

    public long getBufferFlushMaxRows() {
        return this.bufferFlushMaxRows;
    }

    public long getBufferFlushIntervalMillis() {
        return this.bufferFlushIntervalMillis;
    }

    public String toString() {
        return "HBaseWriteOptions{bufferFlushMaxSizeInBytes=" + this.bufferFlushMaxSizeInBytes + ", bufferFlushMaxRows=" + this.bufferFlushMaxRows + ", bufferFlushIntervalMillis=" + this.bufferFlushIntervalMillis + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HBaseWriteOptions that = (HBaseWriteOptions)o;
        return this.bufferFlushMaxSizeInBytes == that.bufferFlushMaxSizeInBytes && this.bufferFlushMaxRows == that.bufferFlushMaxRows && this.bufferFlushIntervalMillis == that.bufferFlushIntervalMillis;
    }

    public int hashCode() {
        return Objects.hash(this.bufferFlushMaxSizeInBytes, this.bufferFlushMaxRows, this.bufferFlushIntervalMillis);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long bufferFlushMaxSizeInBytes = 0x200000L;
        private long bufferFlushMaxRows = 0L;
        private long bufferFlushIntervalMillis = 0L;

        public Builder setBufferFlushMaxSizeInBytes(long bufferFlushMaxSizeInBytes) {
            this.bufferFlushMaxSizeInBytes = bufferFlushMaxSizeInBytes;
            return this;
        }

        public Builder setBufferFlushMaxRows(long bufferFlushMaxRows) {
            this.bufferFlushMaxRows = bufferFlushMaxRows;
            return this;
        }

        public Builder setBufferFlushIntervalMillis(long bufferFlushIntervalMillis) {
            this.bufferFlushIntervalMillis = bufferFlushIntervalMillis;
            return this;
        }

        public HBaseWriteOptions build() {
            return new HBaseWriteOptions(this.bufferFlushMaxSizeInBytes, this.bufferFlushMaxRows, this.bufferFlushIntervalMillis);
        }
    }
}

