/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase;

import java.time.Duration;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.hbase.options.HBaseOptions;
import org.apache.flink.connector.hbase.options.HBaseWriteOptions;
import org.apache.flink.connector.hbase.sink.HBaseDynamicTableSink;
import org.apache.flink.connector.hbase.source.HBaseDynamicTableSource;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;

public class HBaseDynamicTableFactory
implements DynamicTableSourceFactory,
DynamicTableSinkFactory {
    private static final String IDENTIFIER = "hbase-1.4";
    private static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("The name of HBase table to connect.");
    private static final ConfigOption<String> ZOOKEEPER_QUORUM = ConfigOptions.key((String)"zookeeper.quorum").stringType().noDefaultValue().withDescription("The HBase Zookeeper quorum.");
    private static final ConfigOption<String> ZOOKEEPER_ZNODE_PARENT = ConfigOptions.key((String)"zookeeper.znode.parent").stringType().defaultValue((Object)"/hbase").withDescription("The root dir in Zookeeper for HBase cluster.");
    private static final ConfigOption<String> NULL_STRING_LITERAL = ConfigOptions.key((String)"null-string-literal").stringType().defaultValue((Object)"null").withDescription("Representation for null values for string fields. HBase source and sink encodes/decodes empty bytes as null values for all types except string type.");
    private static final ConfigOption<MemorySize> SINK_BUFFER_FLUSH_MAX_SIZE = ConfigOptions.key((String)"sink.buffer-flush.max-size").memoryType().defaultValue((Object)MemorySize.parse((String)"2mb")).withDescription("Writing option, maximum size in memory of buffered rows for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. ");
    private static final ConfigOption<Integer> SINK_BUFFER_FLUSH_MAX_ROWS = ConfigOptions.key((String)"sink.buffer-flush.max-rows").intType().defaultValue((Object)1000).withDescription("Writing option, maximum number of rows to buffer for each writing request. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it.");
    private static final ConfigOption<Duration> SINK_BUFFER_FLUSH_INTERVAL = ConfigOptions.key((String)"sink.buffer-flush.interval").durationType().defaultValue((Object)Duration.ofSeconds(1L)).withDescription("Writing option, the interval to flush any buffered rows. This can improve performance for writing data to HBase database, but may increase the latency. Can be set to '0' to disable it. Note, both 'sink.buffer-flush.max-size' and 'sink.buffer-flush.max-rows' can be set to '0' with the flush interval set allowing for complete async processing of buffered actions.");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        HBaseDynamicTableFactory.validatePrimaryKey(tableSchema);
        String hTableName = (String)helper.getOptions().get(TABLE_NAME);
        Configuration hbaseClientConf = HBaseConfiguration.create();
        hbaseClientConf.set("hbase.zookeeper.quorum", (String)helper.getOptions().get(ZOOKEEPER_QUORUM));
        hbaseClientConf.set("zookeeper.znode.parent", (String)helper.getOptions().get(ZOOKEEPER_ZNODE_PARENT));
        String nullStringLiteral = (String)helper.getOptions().get(NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSource(hbaseClientConf, hTableName, hbaseSchema, nullStringLiteral);
    }

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        HBaseDynamicTableFactory.validatePrimaryKey(tableSchema);
        HBaseOptions.Builder hbaseOptionsBuilder = HBaseOptions.builder();
        hbaseOptionsBuilder.setTableName((String)helper.getOptions().get(TABLE_NAME));
        hbaseOptionsBuilder.setZkQuorum((String)helper.getOptions().get(ZOOKEEPER_QUORUM));
        hbaseOptionsBuilder.setZkNodeParent((String)helper.getOptions().get(ZOOKEEPER_ZNODE_PARENT));
        HBaseWriteOptions.Builder writeBuilder = HBaseWriteOptions.builder();
        writeBuilder.setBufferFlushMaxSizeInBytes(((MemorySize)helper.getOptions().get(SINK_BUFFER_FLUSH_MAX_SIZE)).getBytes());
        writeBuilder.setBufferFlushIntervalMillis(((Duration)helper.getOptions().get(SINK_BUFFER_FLUSH_INTERVAL)).toMillis());
        writeBuilder.setBufferFlushMaxRows(((Integer)helper.getOptions().get(SINK_BUFFER_FLUSH_MAX_ROWS)).intValue());
        String nullStringLiteral = (String)helper.getOptions().get(NULL_STRING_LITERAL);
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(tableSchema);
        return new HBaseDynamicTableSink(hbaseSchema, hbaseOptionsBuilder.build(), writeBuilder.build(), nullStringLiteral);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet set = new HashSet();
        set.add(TABLE_NAME);
        set.add(ZOOKEEPER_QUORUM);
        return set;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet set = new HashSet();
        set.add(ZOOKEEPER_ZNODE_PARENT);
        set.add(NULL_STRING_LITERAL);
        set.add(SINK_BUFFER_FLUSH_MAX_SIZE);
        set.add(SINK_BUFFER_FLUSH_MAX_ROWS);
        set.add(SINK_BUFFER_FLUSH_INTERVAL);
        return set;
    }

    private static void validatePrimaryKey(TableSchema schema) {
        HBaseTableSchema hbaseSchema = HBaseTableSchema.fromTableSchema(schema);
        if (!hbaseSchema.getRowKeyName().isPresent()) {
            throw new IllegalArgumentException("HBase table requires to define a row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
        }
        schema.getPrimaryKey().ifPresent(k -> {
            if (k.getColumns().size() > 1) {
                throw new IllegalArgumentException("HBase table doesn't support a primary Key on multiple columns. The primary key of HBase table must be defined on row key field.");
            }
            if (!hbaseSchema.getRowKeyName().get().equals(k.getColumns().get(0))) {
                throw new IllegalArgumentException("Primary key of HBase table must be defined on the row key field. A row key field is defined as an atomic type, column families and qualifiers are defined as ROW type.");
            }
        });
    }
}

