/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.connector.hbase.util.HBaseTypeUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;

@Internal
public class HBaseTableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<String, DataType>> familyMap = new LinkedHashMap<String, Map<String, DataType>>();
    private RowKeyInfo rowKeyInfo;
    private String charset = "UTF-8";

    public void addColumn(String family, String qualifier, Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (String)"class type");
        DataType type = TypeConversions.fromLegacyInfoToDataType((TypeInformation)TypeExtractor.getForClass(clazz));
        this.addColumn(family, qualifier, type);
    }

    public void addColumn(String family, String qualifier, DataType type) {
        Preconditions.checkNotNull((Object)family, (String)"family name");
        Preconditions.checkNotNull((Object)qualifier, (String)"qualifier name");
        Preconditions.checkNotNull((Object)type, (String)"data type");
        Map<String, DataType> qualifierMap = this.familyMap.get(family);
        if (!HBaseTypeUtils.isSupportedType(type.getLogicalType())) {
            throw new IllegalArgumentException("Unsupported class type found " + type + ". Better to use byte[].class and deserialize using user defined scalar functions");
        }
        if (qualifierMap == null) {
            qualifierMap = new LinkedHashMap<String, DataType>();
        }
        qualifierMap.put(qualifier, type);
        this.familyMap.put(family, qualifierMap);
    }

    public void setRowKey(String rowKeyName, Class<?> clazz) {
        Preconditions.checkNotNull(clazz, (String)"row key class type");
        DataType type = TypeConversions.fromLegacyInfoToDataType((TypeInformation)TypeExtractor.getForClass(clazz));
        this.setRowKey(rowKeyName, type);
    }

    public void setRowKey(String rowKeyName, DataType type) {
        Preconditions.checkNotNull((Object)rowKeyName, (String)"row key field name");
        Preconditions.checkNotNull((Object)type, (String)"row key data type");
        if (!HBaseTypeUtils.isSupportedType(type.getLogicalType())) {
            throw new IllegalArgumentException("Unsupported class type found " + type + ". Better to use byte[].class and deserialize using user defined scalar functions");
        }
        if (this.rowKeyInfo != null) {
            throw new IllegalArgumentException("Row key can't be set multiple times.");
        }
        this.rowKeyInfo = new RowKeyInfo(rowKeyName, type, this.familyMap.size());
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String[] getFamilyNames() {
        return this.familyMap.keySet().toArray(new String[0]);
    }

    public byte[][] getFamilyKeys() {
        Charset c = Charset.forName(this.charset);
        byte[][] familyKeys = new byte[this.familyMap.size()][];
        int i = 0;
        for (String name : this.familyMap.keySet()) {
            familyKeys[i++] = name.getBytes(c);
        }
        return familyKeys;
    }

    public String[] getQualifierNames(String family) {
        Map<String, DataType> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        String[] qualifierNames = new String[qualifierMap.size()];
        int i = 0;
        Iterator<String> iterator = qualifierMap.keySet().iterator();
        while (iterator.hasNext()) {
            String qualifier;
            qualifierNames[i] = qualifier = iterator.next();
            ++i;
        }
        return qualifierNames;
    }

    public byte[][] getQualifierKeys(String family) {
        Map<String, DataType> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        Charset c = Charset.forName(this.charset);
        byte[][] qualifierKeys = new byte[qualifierMap.size()][];
        int i = 0;
        for (String name : qualifierMap.keySet()) {
            qualifierKeys[i++] = name.getBytes(c);
        }
        return qualifierKeys;
    }

    public TypeInformation<?>[] getQualifierTypes(String family) {
        DataType[] dataTypes = this.getQualifierDataTypes(family);
        return (TypeInformation[])Arrays.stream(dataTypes).map(TypeConversions::fromDataTypeToLegacyInfo).toArray(TypeInformation[]::new);
    }

    public DataType[] getQualifierDataTypes(String family) {
        Map<String, DataType> qualifierMap = this.familyMap.get(family);
        if (qualifierMap == null) {
            throw new IllegalArgumentException("Family " + family + " does not exist in schema.");
        }
        DataType[] dataTypes = new DataType[qualifierMap.size()];
        int i = 0;
        Iterator<DataType> iterator = qualifierMap.values().iterator();
        while (iterator.hasNext()) {
            DataType dataType;
            dataTypes[i] = dataType = iterator.next();
            ++i;
        }
        return dataTypes;
    }

    private Map<String, DataType> getFamilyInfo(String family) {
        return this.familyMap.get(family);
    }

    public String getStringCharset() {
        return this.charset;
    }

    public int getRowKeyIndex() {
        return this.rowKeyInfo == null ? -1 : this.rowKeyInfo.rowKeyIndex;
    }

    public Optional<TypeInformation<?>> getRowKeyTypeInfo() {
        return this.rowKeyInfo == null ? Optional.empty() : Optional.of(TypeConversions.fromDataTypeToLegacyInfo((DataType)this.rowKeyInfo.rowKeyType));
    }

    public Optional<DataType> getRowKeyDataType() {
        return this.rowKeyInfo == null ? Optional.empty() : Optional.of(this.rowKeyInfo.rowKeyType);
    }

    public Optional<String> getRowKeyName() {
        return this.rowKeyInfo == null ? Optional.empty() : Optional.of(this.rowKeyInfo.rowKeyName);
    }

    public HBaseTableSchema getProjectedHBaseTableSchema(int[] projectedFields) {
        if (projectedFields == null) {
            return this;
        }
        HBaseTableSchema newSchema = new HBaseTableSchema();
        String[] fieldNames = this.convertsToTableSchema().getFieldNames();
        for (int projectedField : projectedFields) {
            String name = fieldNames[projectedField];
            if (this.rowKeyInfo != null && name.equals(this.rowKeyInfo.rowKeyName)) {
                newSchema.setRowKey(this.rowKeyInfo.rowKeyName, this.rowKeyInfo.rowKeyType);
                continue;
            }
            Map<String, DataType> familyInfo = this.getFamilyInfo(name);
            for (Map.Entry<String, DataType> entry : familyInfo.entrySet()) {
                String qualifier = entry.getKey();
                newSchema.addColumn(name, qualifier, entry.getValue());
            }
        }
        newSchema.setCharset(this.charset);
        return newSchema;
    }

    public TableSchema convertsToTableSchema() {
        String[] familyNames = this.getFamilyNames();
        if (this.rowKeyInfo != null) {
            String[] fieldNames = new String[familyNames.length + 1];
            DataType[] fieldTypes = new DataType[familyNames.length + 1];
            for (int i = 0; i < fieldNames.length; ++i) {
                String family;
                if (i == this.rowKeyInfo.rowKeyIndex) {
                    fieldNames[i] = this.rowKeyInfo.rowKeyName;
                    fieldTypes[i] = this.rowKeyInfo.rowKeyType;
                    continue;
                }
                int familyIndex = i < this.rowKeyInfo.rowKeyIndex ? i : i - 1;
                fieldNames[i] = family = familyNames[familyIndex];
                fieldTypes[i] = TableSchema.builder().fields(this.getQualifierNames(family), this.getQualifierDataTypes(family)).build().toRowDataType();
            }
            return TableSchema.builder().fields(fieldNames, fieldTypes).build();
        }
        String[] fieldNames = new String[familyNames.length];
        DataType[] fieldTypes = new DataType[familyNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            String family;
            fieldNames[i] = family = familyNames[i];
            fieldTypes[i] = TableSchema.builder().fields(this.getQualifierNames(family), this.getQualifierDataTypes(family)).build().toRowDataType();
        }
        return TableSchema.builder().fields(fieldNames, fieldTypes).build();
    }

    public static HBaseTableSchema fromTableSchema(TableSchema schema) {
        HBaseTableSchema hbaseSchema = new HBaseTableSchema();
        RowType rowType = (RowType)schema.toPhysicalRowDataType().getLogicalType();
        for (RowType.RowField field : rowType.getFields()) {
            LogicalType fieldType = field.getType();
            if (fieldType.getTypeRoot() == LogicalTypeRoot.ROW) {
                RowType familyType = (RowType)fieldType;
                String familyName = field.getName();
                for (RowType.RowField qualifier : familyType.getFields()) {
                    hbaseSchema.addColumn(familyName, qualifier.getName(), TypeConversions.fromLogicalToDataType((LogicalType)qualifier.getType()));
                }
                continue;
            }
            if (fieldType.getChildren().size() == 0) {
                hbaseSchema.setRowKey(field.getName(), TypeConversions.fromLogicalToDataType((LogicalType)fieldType));
                continue;
            }
            throw new IllegalArgumentException("Unsupported field type '" + fieldType + "' for HBase.");
        }
        return hbaseSchema;
    }

    private static class RowKeyInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String rowKeyName;
        final DataType rowKeyType;
        final int rowKeyIndex;

        RowKeyInfo(String rowKeyName, DataType rowKeyType, int rowKeyIndex) {
            this.rowKeyName = rowKeyName;
            this.rowKeyType = rowKeyType;
            this.rowKeyIndex = rowKeyIndex;
        }
    }
}

