/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;

@Internal
public class HBaseConfigurationUtil {
    public static byte[] serializeConfiguration(Configuration conf) {
        try {
            return HBaseConfigurationUtil.serializeWritable(conf);
        }
        catch (IOException e) {
            throw new RuntimeException("Encounter an IOException when serialize the Configuration.", e);
        }
    }

    public static Configuration deserializeConfiguration(byte[] serializedConfig, Configuration targetConfig) {
        if (null == targetConfig) {
            targetConfig = new Configuration();
        }
        try {
            HBaseConfigurationUtil.deserializeWritable(targetConfig, serializedConfig);
        }
        catch (IOException e) {
            throw new RuntimeException("Encounter an IOException when deserialize the Configuration.", e);
        }
        return targetConfig;
    }

    private static <T extends Writable> byte[] serializeWritable(T writable) throws IOException {
        Preconditions.checkArgument((writable != null ? 1 : 0) != 0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        writable.write((DataOutput)outputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static <T extends Writable> void deserializeWritable(T writable, byte[] bytes) throws IOException {
        Preconditions.checkArgument((writable != null ? 1 : 0) != 0);
        Preconditions.checkArgument((bytes != null ? 1 : 0) != 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        writable.readFields((DataInput)dataInputStream);
    }
}

