/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.hbase.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.hbase.source.HBaseRowDataInputFormat;
import org.apache.flink.connector.hbase.source.HBaseRowDataLookupFunction;
import org.apache.flink.connector.hbase.util.HBaseTableSchema;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsProjectionPushDown;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

@Internal
public class HBaseDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsProjectionPushDown {
    private final Configuration conf;
    private final String tableName;
    private HBaseTableSchema hbaseSchema;
    private final String nullStringLiteral;

    public HBaseDynamicTableSource(Configuration conf, String tableName, HBaseTableSchema hbaseSchema, String nullStringLiteral) {
        this.conf = conf;
        this.tableName = tableName;
        this.hbaseSchema = hbaseSchema;
        this.nullStringLiteral = nullStringLiteral;
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        return InputFormatProvider.of((InputFormat)new HBaseRowDataInputFormat(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral));
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        Preconditions.checkArgument((context.getKeys().length == 1 && context.getKeys()[0].length == 1 ? 1 : 0) != 0, (Object)"Currently, HBase table can only be lookup by single rowkey.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.getRowKeyName().isPresent(), (Object)"HBase schema must have a row key when used in lookup mode.");
        Preconditions.checkArgument((boolean)this.hbaseSchema.convertsToTableSchema().getTableColumn(context.getKeys()[0][0]).filter(f -> f.getName().equals(this.hbaseSchema.getRowKeyName().get())).isPresent(), (Object)"Currently, HBase table only supports lookup by rowkey field.");
        return TableFunctionProvider.of((TableFunction)new HBaseRowDataLookupFunction(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral));
    }

    public boolean supportsNestedProjection() {
        return false;
    }

    public void applyProjection(int[][] projectedFields) {
        TableSchema projectSchema = TableSchemaUtils.projectSchema((TableSchema)this.hbaseSchema.convertsToTableSchema(), (int[][])projectedFields);
        this.hbaseSchema = HBaseTableSchema.fromTableSchema(projectSchema);
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public DynamicTableSource copy() {
        return new HBaseDynamicTableSource(this.conf, this.tableName, this.hbaseSchema, this.nullStringLiteral);
    }

    public String asSummaryString() {
        return "HBase";
    }

    @VisibleForTesting
    public HBaseTableSchema getHBaseTableSchema() {
        return this.hbaseSchema;
    }
}

