/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flume.FlumeException;
import org.apache.flume.Source;
import org.apache.flume.SourceFactory;
import org.apache.flume.conf.source.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSourceFactory
implements SourceFactory {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSourceFactory.class);

    @Override
    public Source create(String name, String type) throws FlumeException {
        Preconditions.checkNotNull(name, "name");
        Preconditions.checkNotNull(type, "type");
        logger.info("Creating instance of source {}, type {}", (Object)name, (Object)type);
        Class<? extends Source> sourceClass = this.getClass(type);
        try {
            Source source = sourceClass.newInstance();
            source.setName(name);
            return source;
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to create source: " + name + ", type: " + type + ", class: " + sourceClass.getName(), ex);
        }
    }

    @Override
    public Class<? extends Source> getClass(String type) throws FlumeException {
        String sourceClassName = type;
        SourceType srcType = SourceType.OTHER;
        try {
            srcType = SourceType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            logger.debug("Source type {} is a custom type", (Object)type);
        }
        if (!srcType.equals((Object)SourceType.OTHER)) {
            sourceClassName = srcType.getSourceClassName();
        }
        try {
            return Class.forName(sourceClassName);
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load source type: " + type + ", class: " + sourceClassName, ex);
        }
    }
}

