/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import org.apache.flume.Channel;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.event.EventHelper;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerSink
extends AbstractSink {
    private static final Logger logger = LoggerFactory.getLogger(LoggerSink.class);

    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status result = Sink.Status.READY;
        Channel channel = this.getChannel();
        Transaction transaction = channel.getTransaction();
        Event event = null;
        try {
            transaction.begin();
            event = channel.take();
            if (event != null) {
                if (logger.isInfoEnabled()) {
                    logger.info("Event: " + EventHelper.dumpEvent(event));
                }
            } else {
                result = Sink.Status.BACKOFF;
            }
            transaction.commit();
        }
        catch (Exception ex) {
            transaction.rollback();
            throw new EventDeliveryException("Failed to log event: " + event, ex);
        }
        finally {
            transaction.close();
        }
        return result;
    }
}

