/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.flink.shaded.com.google.common.collect.Lists;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.apache.flume.interceptor.StaticInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexFilteringInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(StaticInterceptor.class);
    private final Pattern regex;
    private final boolean excludeEvents;

    private RegexFilteringInterceptor(Pattern regex, boolean excludeEvents) {
        this.regex = regex;
        this.excludeEvents = excludeEvents;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Event intercept(Event event) {
        if (!this.excludeEvents) {
            if (this.regex.matcher(new String(event.getBody())).find()) {
                return event;
            }
            return null;
        }
        if (this.regex.matcher(new String(event.getBody())).find()) {
            return null;
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        ArrayList<Event> out = Lists.newArrayList();
        for (Event event : events) {
            Event outEvent = this.intercept(event);
            if (outEvent == null) continue;
            out.add(outEvent);
        }
        return out;
    }

    @Override
    public void close() {
    }

    public static class Constants {
        public static final String REGEX = "regex";
        public static final String DEFAULT_REGEX = ".*";
        public static final String EXCLUDE_EVENTS = "excludeEvents";
        public static final boolean DEFAULT_EXCLUDE_EVENTS = false;
    }

    public static class Builder
    implements Interceptor.Builder {
        private Pattern regex;
        private boolean excludeEvents;

        @Override
        public void configure(Context context) {
            String regexString = context.getString("regex", ".*");
            this.regex = Pattern.compile(regexString);
            this.excludeEvents = context.getBoolean("excludeEvents", false);
        }

        @Override
        public Interceptor build() {
            logger.info(String.format("Creating RegexFilteringInterceptor: regex=%s,excludeEvents=%s", this.regex, this.excludeEvents));
            return new RegexFilteringInterceptor(this.regex, this.excludeEvents);
        }
    }
}

