/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation.http;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flink.shaded.com.google.gson.Gson;
import org.apache.flink.shaded.com.google.gson.reflect.TypeToken;
import org.apache.flume.Context;
import org.apache.flume.instrumentation.MonitorService;
import org.apache.flume.instrumentation.util.JMXPollUtil;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPMetricsServer
implements MonitorService {
    private Server jettyServer;
    private int port;
    private static Logger LOG = LoggerFactory.getLogger(HTTPMetricsServer.class);
    public static int DEFAULT_PORT = 41414;
    public static String CONFIG_PORT = "port";

    @Override
    public void start() {
        this.jettyServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setReuseAddress(true);
        connector.setPort(this.port);
        this.jettyServer.setConnectors(new Connector[]{connector});
        this.jettyServer.setHandler((Handler)new HTTPMetricsHandler());
        try {
            this.jettyServer.start();
            while (!this.jettyServer.isStarted()) {
                Thread.sleep(500L);
            }
        }
        catch (Exception ex) {
            LOG.error("Error starting Jetty. JSON Metrics may not be available.", (Throwable)ex);
        }
    }

    @Override
    public void stop() {
        try {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
        catch (Exception ex) {
            LOG.error("Error stopping Jetty. JSON Metrics may not be available.", (Throwable)ex);
        }
    }

    @Override
    public void configure(Context context) {
        this.port = context.getInteger(CONFIG_PORT, DEFAULT_PORT);
    }

    private class HTTPMetricsHandler
    extends AbstractHandler {
        Type mapType = new TypeToken<Map<String, Map<String, String>>>(){}.getType();
        Gson gson = new Gson();

        private HTTPMetricsHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (request.getMethod().equalsIgnoreCase("TRACE") || request.getMethod().equalsIgnoreCase("OPTIONS")) {
                response.sendError(403);
                response.flushBuffer();
                ((Request)request).setHandled(true);
                return;
            }
            if (target.equals("/")) {
                response.setContentType("text/html;charset=utf-8");
                response.setStatus(200);
                response.getWriter().write("For Flume metrics please click <a href = \"./metrics\"> here</a>.");
                response.flushBuffer();
                ((Request)request).setHandled(true);
                return;
            }
            if (target.equalsIgnoreCase("/metrics")) {
                response.setContentType("application/json;charset=utf-8");
                response.setStatus(200);
                Map<String, Map<String, String>> metricsMap = JMXPollUtil.getAllMBeans();
                String json = this.gson.toJson(metricsMap, this.mapType);
                response.getWriter().write(json);
                response.flushBuffer();
                ((Request)request).setHandled(true);
                return;
            }
            response.sendError(404);
            response.flushBuffer();
        }
    }
}

