/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel;

import java.util.List;
import java.util.Map;
import org.apache.flume.Channel;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.ReplicatingChannelSelector;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.channel.ChannelSelectorType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelSelectorFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelSelectorFactory.class);

    public static ChannelSelector create(List<Channel> channels, Map<String, String> config) {
        ChannelSelector selector = ChannelSelectorFactory.getSelectorForType(config.get("type"));
        selector.setChannels(channels);
        Context context = new Context();
        context.putAll(config);
        Configurables.configure((Object)selector, context);
        return selector;
    }

    public static ChannelSelector create(List<Channel> channels, ChannelSelectorConfiguration conf) {
        String type = ChannelSelectorType.REPLICATING.toString();
        if (conf != null) {
            type = conf.getType();
        }
        ChannelSelector selector = ChannelSelectorFactory.getSelectorForType(type);
        selector.setChannels(channels);
        Configurables.configure((Object)selector, conf);
        return selector;
    }

    private static ChannelSelector getSelectorForType(String type) {
        if (type == null || type.trim().length() == 0) {
            return new ReplicatingChannelSelector();
        }
        String selectorClassName = type;
        ChannelSelectorType selectorType = ChannelSelectorType.OTHER;
        try {
            selectorType = ChannelSelectorType.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.debug("Selector type {} is a custom type", (Object)type);
        }
        if (!selectorType.equals((Object)ChannelSelectorType.OTHER)) {
            selectorClassName = selectorType.getChannelSelectorClassName();
        }
        ChannelSelector selector = null;
        try {
            Class<?> selectorClass = Class.forName(selectorClassName);
            selector = (ChannelSelector)selectorClass.newInstance();
        }
        catch (Exception ex) {
            throw new FlumeException("Unable to load selector type: " + type + ", class: " + selectorClassName, ex);
        }
        return selector;
    }
}

