/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.com.google.common.collect;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import org.apache.flink.shaded.com.google.common.annotations.GwtCompatible;
import org.apache.flink.shaded.com.google.common.base.Preconditions;
import org.apache.flink.shaded.com.google.common.collect.AbstractMultiset;
import org.apache.flink.shaded.com.google.common.collect.BoundType;
import org.apache.flink.shaded.com.google.common.collect.Multiset;
import org.apache.flink.shaded.com.google.common.collect.Multisets;
import org.apache.flink.shaded.com.google.common.collect.Ordering;
import org.apache.flink.shaded.com.google.common.collect.SortedMultiset;
import org.apache.flink.shaded.com.google.common.collect.SortedMultisets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GwtCompatible
abstract class AbstractSortedMultiset<E>
extends AbstractMultiset<E>
implements SortedMultiset<E> {
    final Comparator<? super E> comparator;
    private transient SortedMultiset<E> descendingMultiset;

    AbstractSortedMultiset() {
        this(Ordering.natural());
    }

    AbstractSortedMultiset(Comparator<? super E> comparator) {
        this.comparator = Preconditions.checkNotNull(comparator);
    }

    @Override
    public SortedSet<E> elementSet() {
        return (SortedSet)super.elementSet();
    }

    @Override
    SortedSet<E> createElementSet() {
        return new SortedMultisets.ElementSet<E>(){

            @Override
            SortedMultiset<E> multiset() {
                return AbstractSortedMultiset.this;
            }
        };
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        Iterator entryIterator = this.entryIterator();
        return entryIterator.hasNext() ? entryIterator.next() : null;
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        return entryIterator.hasNext() ? entryIterator.next() : null;
    }

    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            Multiset.Entry result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            entryIterator.remove();
            return result;
        }
        return null;
    }

    @Override
    public Multiset.Entry<E> pollLastEntry() {
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            Multiset.Entry<E> result = entryIterator.next();
            result = Multisets.immutableEntry(result.getElement(), result.getCount());
            entryIterator.remove();
            return result;
        }
        return null;
    }

    @Override
    public SortedMultiset<E> subMultiset(E fromElement, BoundType fromBoundType, E toElement, BoundType toBoundType) {
        return this.tailMultiset(fromElement, fromBoundType).headMultiset(toElement, toBoundType);
    }

    abstract Iterator<Multiset.Entry<E>> descendingEntryIterator();

    Iterator<E> descendingIterator() {
        return Multisets.iteratorImpl(this.descendingMultiset());
    }

    @Override
    public SortedMultiset<E> descendingMultiset() {
        SortedMultiset<E> result = this.descendingMultiset;
        return result == null ? (this.descendingMultiset = this.createDescendingMultiset()) : result;
    }

    SortedMultiset<E> createDescendingMultiset() {
        return new SortedMultisets.DescendingMultiset<E>(){

            @Override
            SortedMultiset<E> forwardMultiset() {
                return AbstractSortedMultiset.this;
            }

            @Override
            Iterator<Multiset.Entry<E>> entryIterator() {
                return AbstractSortedMultiset.this.descendingEntryIterator();
            }

            @Override
            public Iterator<E> iterator() {
                return AbstractSortedMultiset.this.descendingIterator();
            }
        };
    }
}

