/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.SuggestMode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.SuggestWord;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.phrase.CandidateGenerator;

public final class DirectCandidateGenerator
extends CandidateGenerator {
    private final DirectSpellChecker spellchecker;
    private final String field;
    private final SuggestMode suggestMode;
    private final TermsEnum termsEnum;
    private final IndexReader reader;
    private final long dictSize;
    private final double logBase = 5.0;
    private final long frequencyPlateau;
    private final Analyzer preFilter;
    private final Analyzer postFilter;
    private final double nonErrorLikelihood;
    private final boolean useTotalTermFrequency;
    private final CharsRefBuilder spare = new CharsRefBuilder();
    private final BytesRefBuilder byteSpare = new BytesRefBuilder();
    private final int numCandidates;

    public DirectCandidateGenerator(DirectSpellChecker spellchecker, String field, SuggestMode suggestMode, IndexReader reader, double nonErrorLikelihood, int numCandidates) throws IOException {
        this(spellchecker, field, suggestMode, reader, nonErrorLikelihood, numCandidates, null, null, MultiFields.getTerms(reader, field));
    }

    public DirectCandidateGenerator(DirectSpellChecker spellchecker, String field, SuggestMode suggestMode, IndexReader reader, double nonErrorLikelihood, int numCandidates, Analyzer preFilter, Analyzer postFilter, Terms terms) throws IOException {
        if (terms == null) {
            throw new ElasticsearchIllegalArgumentException("generator field [" + field + "] doesn't exist");
        }
        this.spellchecker = spellchecker;
        this.field = field;
        this.numCandidates = numCandidates;
        this.suggestMode = suggestMode;
        this.reader = reader;
        long dictSize = terms.getSumTotalTermFreq();
        this.useTotalTermFrequency = dictSize != -1L;
        this.dictSize = dictSize == -1L ? (long)reader.maxDoc() : dictSize;
        this.preFilter = preFilter;
        this.postFilter = postFilter;
        this.nonErrorLikelihood = nonErrorLikelihood;
        float thresholdFrequency = spellchecker.getThresholdFrequency();
        this.frequencyPlateau = thresholdFrequency >= 1.0f ? (long)((int)thresholdFrequency) : (long)((int)((float)dictSize * thresholdFrequency));
        this.termsEnum = terms.iterator(null);
    }

    @Override
    public boolean isKnownWord(BytesRef term) throws IOException {
        return this.frequency(term) > 0L;
    }

    @Override
    public long frequency(BytesRef term) throws IOException {
        term = this.preFilter(term, this.spare, this.byteSpare);
        return this.internalFrequency(term);
    }

    public long internalFrequency(BytesRef term) throws IOException {
        if (this.termsEnum.seekExact(term)) {
            return this.useTotalTermFrequency ? this.termsEnum.totalTermFreq() : (long)this.termsEnum.docFreq();
        }
        return 0L;
    }

    public String getField() {
        return this.field;
    }

    @Override
    public CandidateSet drawCandidates(CandidateSet set) throws IOException {
        Candidate original = set.originalTerm;
        BytesRef term = this.preFilter(original.term, this.spare, this.byteSpare);
        long frequency = original.frequency;
        this.spellchecker.setThresholdFrequency(this.suggestMode == SuggestMode.SUGGEST_ALWAYS ? 0.0f : (float)this.thresholdFrequency(frequency, this.dictSize));
        SuggestWord[] suggestSimilar = this.spellchecker.suggestSimilar(new Term(this.field, term), this.numCandidates, this.reader, this.suggestMode);
        ArrayList<Candidate> candidates = new ArrayList<Candidate>(suggestSimilar.length);
        for (int i = 0; i < suggestSimilar.length; ++i) {
            SuggestWord suggestWord = suggestSimilar[i];
            BytesRef candidate = new BytesRef(suggestWord.string);
            this.postFilter(new Candidate(candidate, this.internalFrequency(candidate), suggestWord.score, this.score(suggestWord.freq, suggestWord.score, this.dictSize), false), this.spare, this.byteSpare, candidates);
        }
        set.addCandidates(candidates);
        return set;
    }

    protected BytesRef preFilter(BytesRef term, CharsRefBuilder spare, BytesRefBuilder byteSpare) throws IOException {
        if (this.preFilter == null) {
            return term;
        }
        final BytesRefBuilder result = byteSpare;
        SuggestUtils.analyze(this.preFilter, term, this.field, new SuggestUtils.TokenConsumer(){

            @Override
            public void nextToken() throws IOException {
                this.fillBytesRef(result);
            }
        }, spare);
        return result.get();
    }

    protected void postFilter(final Candidate candidate, CharsRefBuilder spare, BytesRefBuilder byteSpare, final List<Candidate> candidates) throws IOException {
        if (this.postFilter == null) {
            candidates.add(candidate);
        } else {
            final BytesRefBuilder result = byteSpare;
            SuggestUtils.analyze(this.postFilter, candidate.term, this.field, new SuggestUtils.TokenConsumer(){

                @Override
                public void nextToken() throws IOException {
                    this.fillBytesRef(result);
                    if (this.posIncAttr.getPositionIncrement() > 0 && result.get().bytesEquals(candidate.term)) {
                        BytesRef term = result.toBytesRef();
                        long freq = DirectCandidateGenerator.this.frequency(term);
                        candidates.add(new Candidate(result.toBytesRef(), freq, candidate.stringDistance, DirectCandidateGenerator.this.score(candidate.frequency, candidate.stringDistance, DirectCandidateGenerator.this.dictSize), false));
                    } else {
                        candidates.add(new Candidate(result.toBytesRef(), candidate.frequency, DirectCandidateGenerator.this.nonErrorLikelihood, DirectCandidateGenerator.this.score(candidate.frequency, candidate.stringDistance, DirectCandidateGenerator.this.dictSize), false));
                    }
                }
            }, spare);
        }
    }

    private double score(long frequency, double errorScore, long dictionarySize) {
        return errorScore * (((double)frequency + 1.0) / ((double)dictionarySize + 1.0));
    }

    protected long thresholdFrequency(long termFrequency, long dictionarySize) {
        if (termFrequency > 0L) {
            return Math.max(0L, Math.round((double)termFrequency * (Math.log10(termFrequency - this.frequencyPlateau) * (1.0 / Math.log10(5.0))) + 1.0));
        }
        return 0L;
    }

    @Override
    public Candidate createCandidate(BytesRef term, long frequency, double channelScore, boolean userInput) throws IOException {
        return new Candidate(term, frequency, channelScore, this.score(frequency, channelScore, this.dictSize), userInput);
    }

    public static class Candidate
    implements Comparable<Candidate> {
        public static final Candidate[] EMPTY = new Candidate[0];
        public final BytesRef term;
        public final double stringDistance;
        public final long frequency;
        public final double score;
        public final boolean userInput;

        public Candidate(BytesRef term, long frequency, double stringDistance, double score, boolean userInput) {
            this.frequency = frequency;
            this.term = term;
            this.stringDistance = stringDistance;
            this.score = score;
            this.userInput = userInput;
        }

        public String toString() {
            return "Candidate [term=" + this.term.utf8ToString() + ", stringDistance=" + this.stringDistance + ", score=" + this.score + ", frequency=" + this.frequency + (this.userInput ? ", userInput" : "") + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.term == null ? 0 : this.term.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Candidate other = (Candidate)obj;
            return !(this.term == null ? other.term != null : !this.term.equals(other.term));
        }

        @Override
        public int compareTo(Candidate other) {
            if (this.score == other.score) {
                return other.term.compareTo(this.term);
            }
            return Double.compare(this.score, other.score);
        }
    }

    public static class CandidateSet {
        public Candidate[] candidates;
        public final Candidate originalTerm;

        public CandidateSet(Candidate[] candidates, Candidate originalTerm) {
            this.candidates = candidates;
            this.originalTerm = originalTerm;
        }

        public void addCandidates(List<Candidate> candidates) {
            HashSet<Candidate> set = new HashSet<Candidate>(candidates);
            for (int i = 0; i < this.candidates.length; ++i) {
                set.add(this.candidates[i]);
            }
            this.candidates = set.toArray(new Candidate[set.size()]);
            Arrays.sort(this.candidates, Collections.reverseOrder());
        }

        public void addOneCandidate(Candidate candidate) {
            Candidate[] candidates = new Candidate[this.candidates.length + 1];
            System.arraycopy(this.candidates, 0, candidates, 0, this.candidates.length);
            candidates[candidates.length - 1] = candidate;
            this.candidates = candidates;
        }
    }
}

