/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.CharsRefBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.SearchPhase;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.SuggestParseElement;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public class SuggestPhase
extends AbstractComponent
implements SearchPhase {
    private final SuggestParseElement parseElement;

    @Inject
    public SuggestPhase(Settings settings, SuggestParseElement suggestParseElement) {
        super(settings);
        this.parseElement = suggestParseElement;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        ImmutableMap.Builder<String, SuggestParseElement> parseElements = ImmutableMap.builder();
        parseElements.put("suggest", this.parseElement);
        return parseElements.build();
    }

    public SuggestParseElement parseElement() {
        return this.parseElement;
    }

    @Override
    public void preProcess(SearchContext context) {
    }

    @Override
    public void execute(SearchContext context) throws ElasticsearchException {
        SuggestionSearchContext suggest = context.suggest();
        if (suggest == null) {
            return;
        }
        context.queryResult().suggest(this.execute(suggest, context.searcher()));
    }

    public Suggest execute(SuggestionSearchContext suggest, IndexSearcher searcher) {
        try {
            CharsRefBuilder spare = new CharsRefBuilder();
            ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>> suggestions = new ArrayList<Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>>>(suggest.suggestions().size());
            for (Map.Entry<String, SuggestionSearchContext.SuggestionContext> entry : suggest.suggestions().entrySet()) {
                SuggestionSearchContext.SuggestionContext suggestion = entry.getValue();
                Suggester<SuggestionSearchContext.SuggestionContext> suggester = suggestion.getSuggester();
                Suggest.Suggestion<Suggest.Suggestion.Entry<Suggest.Suggestion.Entry.Option>> result = suggester.execute(entry.getKey(), suggestion, searcher, spare);
                if (result == null) continue;
                assert (entry.getKey().equals(result.name));
                suggestions.add(result);
            }
            return new Suggest(Suggest.Fields.SUGGEST, suggestions);
        }
        catch (IOException e) {
            throw new ElasticsearchException("I/O exception during suggest phase", e);
        }
    }
}

