/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.query.support.NestedInnerQueryParseSupport;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class ScriptSortParser
implements SortParser {
    private static final String STRING_SORT_TYPE = "string";
    private static final String NUMBER_SORT_TYPE = "number";

    @Override
    public String[] names() {
        return new String[]{"_script"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        IndexFieldData.XFieldComparatorSource fieldComparatorSource;
        IndexFieldData.XFieldComparatorSource.Nested nested;
        XContentParser.Token token;
        String script = null;
        String scriptLang = null;
        String type = null;
        Map<String, Object> params = null;
        boolean reverse = false;
        MultiValueMode sortMode = null;
        NestedInnerQueryParseSupport nestedHelper = null;
        String currentName = parser.currentName();
        ScriptService.ScriptType scriptType = ScriptService.ScriptType.INLINE;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("params".equals(currentName)) {
                    params = parser.map();
                    continue;
                }
                if (!"nested_filter".equals(currentName) && !"nestedFilter".equals(currentName)) continue;
                if (nestedHelper == null) {
                    nestedHelper = new NestedInnerQueryParseSupport(parser, context);
                }
                nestedHelper.filter();
                continue;
            }
            if (!token.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse = "desc".equals(parser.text());
                continue;
            }
            if (ScriptService.SCRIPT_INLINE.match(currentName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.INLINE;
                continue;
            }
            if (ScriptService.SCRIPT_ID.match(currentName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if (ScriptService.SCRIPT_FILE.match(currentName)) {
                script = parser.text();
                scriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if (ScriptService.SCRIPT_LANG.match(currentName)) {
                scriptLang = parser.text();
                continue;
            }
            if ("type".equals(currentName)) {
                type = parser.text();
                continue;
            }
            if ("mode".equals(currentName)) {
                sortMode = MultiValueMode.fromString(parser.text());
                continue;
            }
            if (!"nested_path".equals(currentName) && !"nestedPath".equals(currentName)) continue;
            if (nestedHelper == null) {
                nestedHelper = new NestedInnerQueryParseSupport(parser, context);
            }
            nestedHelper.setPath(parser.text());
        }
        if (script == null) {
            throw new SearchParseException(context, "_script sorting requires setting the script to sort by");
        }
        if (type == null) {
            throw new SearchParseException(context, "_script sorting requires setting the type of the script");
        }
        final SearchScript searchScript = context.scriptService().search(context.lookup(), scriptLang, script, scriptType, ScriptContext.Standard.SEARCH, params);
        if (STRING_SORT_TYPE.equals(type) && (sortMode == MultiValueMode.SUM || sortMode == MultiValueMode.AVG)) {
            throw new SearchParseException(context, "type [string] doesn't support mode [" + (Object)((Object)sortMode) + "]");
        }
        if (sortMode == null) {
            MultiValueMode multiValueMode = sortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (nestedHelper != null && nestedHelper.getPath() != null) {
            FixedBitSetFilter rootDocumentsFilter = context.fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE);
            FixedBitSetFilter innerDocumentsFilter = nestedHelper.filterFound() ? context.fixedBitSetFilterCache().getFixedBitSetFilter(nestedHelper.getInnerFilter()) : context.fixedBitSetFilterCache().getFixedBitSetFilter(nestedHelper.getNestedObjectMapper().nestedTypeFilter());
            nested = new IndexFieldData.XFieldComparatorSource.Nested(rootDocumentsFilter, innerDocumentsFilter);
        } else {
            nested = null;
        }
        switch (type) {
            case "string": {
                fieldComparatorSource = new BytesRefFieldComparatorSource(null, null, sortMode, nested){

                    @Override
                    protected SortedBinaryDocValues getValues(AtomicReaderContext context) {
                        searchScript.setNextReader(context);
                        BinaryDocValues values = new BinaryDocValues(){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            @Override
                            public BytesRef get(int docID) {
                                searchScript.setNextDocId(docID);
                                this.spare.copyChars(searchScript.run().toString());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        searchScript.setScorer(scorer);
                    }
                };
                break;
            }
            case "number": {
                fieldComparatorSource = new DoubleValuesComparatorSource(null, Double.MAX_VALUE, sortMode, nested){

                    @Override
                    protected SortedNumericDoubleValues getValues(AtomicReaderContext context) {
                        searchScript.setNextReader(context);
                        NumericDoubleValues values = new NumericDoubleValues(){

                            @Override
                            public double get(int docID) {
                                searchScript.setNextDocId(docID);
                                return searchScript.runAsDouble();
                            }
                        };
                        return FieldData.singleton(values, null);
                    }

                    @Override
                    protected void setScorer(Scorer scorer) {
                        searchScript.setScorer(scorer);
                    }
                };
                break;
            }
            default: {
                throw new SearchParseException(context, "custom script sort type [" + type + "] not supported");
            }
        }
        return new SortField("_script", fieldComparatorSource, reverse);
    }
}

