/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.scan;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AllDocIdSet;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.search.internal.SearchContext;

public class ScanContext {
    private final ConcurrentMap<IndexReader, ReaderState> readerStates = ConcurrentCollections.newConcurrentMap();

    public void clear() {
        this.readerStates.clear();
    }

    public TopDocs execute(SearchContext context) throws IOException {
        ScanCollector collector = new ScanCollector(this.readerStates, context.from(), context.size(), context.trackScores());
        XFilteredQuery query = new XFilteredQuery(context.query(), new ScanFilter(this.readerStates, collector));
        try {
            context.searcher().search((Query)query, collector);
        }
        catch (ScanCollector.StopCollectingException e) {
            // empty catch block
        }
        return collector.topDocs();
    }

    static class ReaderState {
        public int count;
        public boolean done;

        ReaderState() {
        }
    }

    public static class ScanFilter
    extends Filter {
        private final ConcurrentMap<IndexReader, ReaderState> readerStates;
        private final ScanCollector scanCollector;

        public ScanFilter(ConcurrentMap<IndexReader, ReaderState> readerStates, ScanCollector scanCollector) {
            this.readerStates = readerStates;
            this.scanCollector = scanCollector;
        }

        @Override
        public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptedDocs) throws IOException {
            ReaderState readerState = (ReaderState)this.readerStates.get(context.reader());
            if (readerState != null && readerState.done) {
                this.scanCollector.incCounter(readerState.count);
                return null;
            }
            return new AllDocIdSet(context.reader().maxDoc());
        }
    }

    static class ScanCollector
    extends Collector {
        private final ConcurrentMap<IndexReader, ReaderState> readerStates;
        private final int from;
        private final int to;
        private final ArrayList<ScoreDoc> docs;
        private final boolean trackScores;
        private Scorer scorer;
        private int docBase;
        private int counter;
        private IndexReader currentReader;
        private ReaderState readerState;
        public static final RuntimeException StopCollectingException = new StopCollectingException();

        ScanCollector(ConcurrentMap<IndexReader, ReaderState> readerStates, int from, int size, boolean trackScores) {
            this.readerStates = readerStates;
            this.from = from;
            this.to = from + size;
            this.trackScores = trackScores;
            this.docs = new ArrayList(size);
        }

        void incCounter(int count) {
            this.counter += count;
        }

        public TopDocs topDocs() {
            return new TopDocs(this.docs.size(), this.docs.toArray(new ScoreDoc[this.docs.size()]), 0.0f);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.counter >= this.from) {
                this.docs.add(new ScoreDoc(this.docBase + doc, this.trackScores ? this.scorer.score() : 0.0f));
            }
            ++this.readerState.count;
            ++this.counter;
            if (this.counter >= this.to) {
                throw StopCollectingException;
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.currentReader != null && !this.readerStates.containsKey(this.currentReader)) {
                assert (this.readerState != null);
                this.readerState.done = true;
                this.readerStates.put(this.currentReader, this.readerState);
            }
            this.currentReader = context.reader();
            this.docBase = context.docBase;
            this.readerState = new ReaderState();
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        static class StopCollectingException
        extends RuntimeException {
            StopCollectingException() {
            }

            @Override
            public Throwable fillInStackTrace() {
                return null;
            }
        }
    }
}

