/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.lookup;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CompositeReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.util.MinimalMap;
import org.elasticsearch.search.lookup.IndexField;

public class IndexLookup
extends MinimalMap<String, IndexField> {
    public static final int FLAG_OFFSETS = 2;
    public static final int FLAG_PAYLOADS = 4;
    public static final int FLAG_FREQUENCIES = 8;
    public static final int FLAG_POSITIONS = 16;
    public static final int FLAG_CACHE = 32;
    private AtomicReader reader;
    private CompositeReader parentReader;
    private IndexSearcher indexSearcher;
    private IndexReaderContext indexReaderContext;
    private int docId = -1;
    private final Map<String, IndexField> indexFields = new HashMap<String, IndexField>();
    private int numDocs = -1;
    private int maxDoc = -1;
    private int numDeletedDocs = -1;

    public int numDocs() {
        if (this.numDocs == -1) {
            this.numDocs = this.parentReader.numDocs();
        }
        return this.numDocs;
    }

    public int maxDoc() {
        if (this.maxDoc == -1) {
            this.maxDoc = this.parentReader.maxDoc();
        }
        return this.maxDoc;
    }

    public int numDeletedDocs() {
        if (this.numDeletedDocs == -1) {
            this.numDeletedDocs = this.parentReader.numDeletedDocs();
        }
        return this.numDeletedDocs;
    }

    public IndexLookup(ImmutableMap.Builder<String, Object> builder) {
        builder.put("_FREQUENCIES", 8);
        builder.put("_POSITIONS", 16);
        builder.put("_OFFSETS", 2);
        builder.put("_PAYLOADS", 4);
        builder.put("_CACHE", 32);
    }

    public void setNextReader(AtomicReaderContext context) {
        if (this.reader == context.reader()) {
            return;
        }
        if (context.parent != null) {
            if (this.parentReader == null) {
                this.parentReader = context.parent.reader();
                this.indexSearcher = new IndexSearcher(this.parentReader);
                this.indexReaderContext = context.parent;
            } else assert (this.parentReader == context.parent.reader());
        } else assert (this.parentReader == null);
        this.reader = context.reader();
        this.docId = -1;
        this.setReaderInFields();
    }

    protected void setReaderInFields() {
        for (IndexField stat : this.indexFields.values()) {
            stat.setReader(this.reader);
        }
    }

    public void setNextDocId(int docId) {
        if (this.docId == docId) {
            return;
        }
        if (this.docId > docId) {
            this.indexFields.clear();
        }
        this.docId = docId;
        this.setNextDocIdInFields();
    }

    protected void setNextDocIdInFields() {
        for (IndexField stat : this.indexFields.values()) {
            stat.setDocIdInTerms(this.docId);
        }
    }

    @Override
    public IndexField get(Object key) {
        String stringField = (String)key;
        IndexField indexField = this.indexFields.get(key);
        if (indexField == null) {
            try {
                indexField = new IndexField(stringField, this);
                this.indexFields.put(stringField, indexField);
            }
            catch (IOException e) {
                throw new ElasticsearchException(e.getMessage());
            }
        }
        return indexField;
    }

    public Fields termVectors() throws IOException {
        assert (this.reader != null);
        return this.reader.getTermVectors(this.docId);
    }

    AtomicReader getReader() {
        return this.reader;
    }

    public int getDocId() {
        return this.docId;
    }

    public IndexReader getParentReader() {
        if (this.parentReader == null) {
            return this.reader;
        }
        return this.parentReader;
    }

    public IndexSearcher getIndexSearcher() {
        if (this.indexSearcher == null) {
            return new IndexSearcher(this.reader);
        }
        return this.indexSearcher;
    }

    public IndexReaderContext getReaderContext() {
        return this.indexReaderContext;
    }
}

