/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.index.cache.docset.DocSetCache;

public class DocIdSetCollector
extends XCollector
implements Releasable {
    private final DocSetCache docSetCache;
    private final Collector collector;
    private final List<ContextDocIdSet> docSets;
    private boolean currentHasDocs;
    private ContextDocIdSet currentContext;
    private FixedBitSet currentSet;

    public DocIdSetCollector(DocSetCache docSetCache, Collector collector) {
        this.docSetCache = docSetCache;
        this.collector = collector;
        this.docSets = new ArrayList<ContextDocIdSet>();
    }

    public List<ContextDocIdSet> docSets() {
        return this.docSets;
    }

    @Override
    public void close() {
        for (ContextDocIdSet docSet : this.docSets) {
            this.docSetCache.release(docSet);
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.collector.setScorer(scorer);
    }

    @Override
    public void collect(int doc) throws IOException {
        this.collector.collect(doc);
        this.currentHasDocs = true;
        this.currentSet.set(doc);
    }

    @Override
    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.collector.setNextReader(context);
        if (this.currentContext != null) {
            if (this.currentHasDocs) {
                this.docSets.add(this.currentContext);
            } else {
                this.docSetCache.release(this.currentContext);
            }
        }
        this.currentContext = this.docSetCache.obtain(context);
        this.currentSet = (FixedBitSet)this.currentContext.docSet;
        this.currentHasDocs = false;
    }

    @Override
    public void postCollection() throws IOException {
        if (this.collector instanceof XCollector) {
            ((XCollector)this.collector).postCollection();
        }
        if (this.currentContext != null) {
            if (this.currentHasDocs) {
                this.docSets.add(this.currentContext);
            } else {
                this.docSetCache.release(this.currentContext);
            }
            this.currentContext = null;
            this.currentSet = null;
            this.currentHasDocs = false;
        }
    }

    @Override
    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

