/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Counter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.common.HasContext;
import org.elasticsearch.common.HasContextAndHeaders;
import org.elasticsearch.common.HasHeaders;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.hppc.ObjectObjectAssociativeContainer;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.search.AndFilter;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.lucene.search.XConstantScoreQuery;
import org.elasticsearch.common.lucene.search.XFilteredQuery;
import org.elasticsearch.common.lucene.search.function.BoostScoreFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.docset.DocSetCache;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilterCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.query.ParsedQuery;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.aggregations.SearchContextAggregations;
import org.elasticsearch.search.dfs.DfsSearchResult;
import org.elasticsearch.search.facet.SearchContextFacets;
import org.elasticsearch.search.fetch.FetchSearchResult;
import org.elasticsearch.search.fetch.fielddata.FieldDataFieldsContext;
import org.elasticsearch.search.fetch.innerhits.InnerHitsContext;
import org.elasticsearch.search.fetch.partial.PartialFieldsContext;
import org.elasticsearch.search.fetch.script.ScriptFieldsContext;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.query.QueryPhaseExecutionException;
import org.elasticsearch.search.query.QuerySearchResult;
import org.elasticsearch.search.rescore.RescoreSearchContext;
import org.elasticsearch.search.scan.ScanContext;
import org.elasticsearch.search.suggest.SuggestionSearchContext;

public class DefaultSearchContext
extends SearchContext {
    private final long id;
    private final ShardSearchRequest request;
    private final SearchShardTarget shardTarget;
    private final Counter timeEstimateCounter;
    private SearchType searchType;
    private final Engine.Searcher engineSearcher;
    private final ScriptService scriptService;
    private final CacheRecycler cacheRecycler;
    private final PageCacheRecycler pageCacheRecycler;
    private final BigArrays bigArrays;
    private final IndexShard indexShard;
    private final IndexService indexService;
    private final ContextIndexSearcher searcher;
    private final DfsSearchResult dfsResult;
    private final QuerySearchResult queryResult;
    private final FetchSearchResult fetchResult;
    private ScanContext scanContext;
    private float queryBoost = 1.0f;
    private long timeoutInMillis = -1L;
    private int terminateAfter = 0;
    private List<String> groupStats;
    private Scroll scroll;
    private boolean explain;
    private boolean version = false;
    private List<String> fieldNames;
    private FieldDataFieldsContext fieldDataFields;
    private ScriptFieldsContext scriptFields;
    private PartialFieldsContext partialFields;
    private FetchSourceContext fetchSourceContext;
    private int from = -1;
    private int size = -1;
    private Sort sort;
    private Float minimumScore;
    private boolean trackScores = false;
    private ParsedQuery originalQuery;
    private Query query;
    private ParsedFilter postFilter;
    private Filter aliasFilter;
    private int[] docIdsToLoad;
    private int docsIdsToLoadFrom;
    private int docsIdsToLoadSize;
    private SearchContextAggregations aggregations;
    private SearchContextFacets facets;
    private SearchContextHighlight highlight;
    private SuggestionSearchContext suggest;
    private List<RescoreSearchContext> rescore;
    private SearchLookup searchLookup;
    private boolean queryRewritten;
    private volatile long keepAlive;
    private ScoreDoc lastEmittedDoc;
    private volatile long lastAccessTime = -1L;
    private volatile boolean useSlowScroll;
    private InnerHitsContext innerHitsContext;

    public DefaultSearchContext(long id, ShardSearchRequest request, SearchShardTarget shardTarget, Engine.Searcher engineSearcher, IndexService indexService, IndexShard indexShard, ScriptService scriptService, CacheRecycler cacheRecycler, PageCacheRecycler pageCacheRecycler, BigArrays bigArrays, Counter timeEstimateCounter) {
        this.id = id;
        this.request = request;
        this.searchType = request.searchType();
        this.shardTarget = shardTarget;
        this.engineSearcher = engineSearcher;
        this.scriptService = scriptService;
        this.cacheRecycler = cacheRecycler;
        this.pageCacheRecycler = pageCacheRecycler;
        this.bigArrays = bigArrays.withCircuitBreaking();
        this.dfsResult = new DfsSearchResult(id, shardTarget);
        this.queryResult = new QuerySearchResult(id, shardTarget);
        this.fetchResult = new FetchSearchResult(id, shardTarget);
        this.indexShard = indexShard;
        this.indexService = indexService;
        this.searcher = new ContextIndexSearcher(this, engineSearcher);
        this.aliasFilter = indexService.aliasesService().aliasFilter(request.filteringAliases());
        this.timeEstimateCounter = timeEstimateCounter;
    }

    @Override
    public void doClose() throws ElasticsearchException {
        if (this.scanContext != null) {
            this.scanContext.clear();
        }
        Releasables.close(this.searcher, this.engineSearcher);
    }

    @Override
    public void preProcess() {
        Filter searchFilter;
        int numHits;
        if ((this.from() != -1 || this.size() != -1) && (numHits = this.from() + this.size()) < 0) {
            String msg = "Result window is too large, from + size must be less than or equal to: [2147483647] but was [" + ((long)this.from() + (long)this.size()) + "]";
            throw new QueryPhaseExecutionException(this, msg);
        }
        if (this.query() == null) {
            this.parsedQuery(ParsedQuery.parsedMatchAllQuery());
        }
        if (this.queryBoost() != 1.0f) {
            this.parsedQuery(new ParsedQuery((Query)new FunctionScoreQuery(this.query(), new BoostScoreFunction(this.queryBoost)), this.parsedQuery()));
        }
        if ((searchFilter = this.searchFilter(this.types())) != null) {
            if (Queries.isConstantMatchAllQuery(this.query())) {
                XConstantScoreQuery q = new XConstantScoreQuery(searchFilter);
                q.setBoost(this.query().getBoost());
                this.parsedQuery(new ParsedQuery((Query)q, this.parsedQuery()));
            } else {
                this.parsedQuery(new ParsedQuery((Query)new XFilteredQuery(this.query(), searchFilter), this.parsedQuery()));
            }
        }
    }

    @Override
    public Filter searchFilter(String[] types) {
        Filter filter = this.mapperService().searchFilter(types);
        if (filter == null) {
            return this.aliasFilter;
        }
        filter = this.filterCache().cache(filter);
        if (this.aliasFilter != null) {
            return new AndFilter(ImmutableList.of(filter, this.aliasFilter));
        }
        return filter;
    }

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public String source() {
        return this.engineSearcher.source();
    }

    @Override
    public ShardSearchRequest request() {
        return this.request;
    }

    @Override
    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public SearchContext searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    @Override
    public SearchShardTarget shardTarget() {
        return this.shardTarget;
    }

    @Override
    public int numberOfShards() {
        return this.request.numberOfShards();
    }

    @Override
    public boolean hasTypes() {
        return this.request.types() != null && this.request.types().length > 0;
    }

    @Override
    public String[] types() {
        return this.request.types();
    }

    @Override
    public float queryBoost() {
        return this.queryBoost;
    }

    @Override
    public SearchContext queryBoost(float queryBoost) {
        this.queryBoost = queryBoost;
        return this;
    }

    @Override
    protected long nowInMillisImpl() {
        return this.request.nowInMillis();
    }

    @Override
    public Scroll scroll() {
        return this.scroll;
    }

    @Override
    public SearchContext scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public SearchContextAggregations aggregations() {
        return this.aggregations;
    }

    @Override
    public SearchContext aggregations(SearchContextAggregations aggregations) {
        this.aggregations = aggregations;
        return this;
    }

    @Override
    public SearchContextFacets facets() {
        return this.facets;
    }

    @Override
    public SearchContext facets(SearchContextFacets facets) {
        this.facets = facets;
        return this;
    }

    @Override
    public SearchContextHighlight highlight() {
        return this.highlight;
    }

    @Override
    public void highlight(SearchContextHighlight highlight) {
        this.highlight = highlight;
    }

    @Override
    public SuggestionSearchContext suggest() {
        return this.suggest;
    }

    @Override
    public void suggest(SuggestionSearchContext suggest) {
        this.suggest = suggest;
    }

    @Override
    public List<RescoreSearchContext> rescore() {
        if (this.rescore == null) {
            return Collections.emptyList();
        }
        return this.rescore;
    }

    @Override
    public void addRescore(RescoreSearchContext rescore) {
        if (this.rescore == null) {
            this.rescore = new ArrayList<RescoreSearchContext>();
        }
        this.rescore.add(rescore);
    }

    @Override
    public boolean hasFieldDataFields() {
        return this.fieldDataFields != null;
    }

    @Override
    public FieldDataFieldsContext fieldDataFields() {
        if (this.fieldDataFields == null) {
            this.fieldDataFields = new FieldDataFieldsContext();
        }
        return this.fieldDataFields;
    }

    @Override
    public boolean hasScriptFields() {
        return this.scriptFields != null;
    }

    @Override
    public ScriptFieldsContext scriptFields() {
        if (this.scriptFields == null) {
            this.scriptFields = new ScriptFieldsContext();
        }
        return this.scriptFields;
    }

    @Override
    public boolean hasPartialFields() {
        return this.partialFields != null;
    }

    @Override
    public PartialFieldsContext partialFields() {
        if (this.partialFields == null) {
            this.partialFields = new PartialFieldsContext();
        }
        return this.partialFields;
    }

    @Override
    public boolean sourceRequested() {
        return this.fetchSourceContext != null && this.fetchSourceContext.fetchSource();
    }

    @Override
    public boolean hasFetchSourceContext() {
        return this.fetchSourceContext != null;
    }

    @Override
    public FetchSourceContext fetchSourceContext() {
        return this.fetchSourceContext;
    }

    @Override
    public SearchContext fetchSourceContext(FetchSourceContext fetchSourceContext) {
        this.fetchSourceContext = fetchSourceContext;
        return this;
    }

    @Override
    public ContextIndexSearcher searcher() {
        return this.searcher;
    }

    @Override
    public IndexShard indexShard() {
        return this.indexShard;
    }

    @Override
    public MapperService mapperService() {
        return this.indexService.mapperService();
    }

    @Override
    public AnalysisService analysisService() {
        return this.indexService.analysisService();
    }

    @Override
    public IndexQueryParserService queryParserService() {
        return this.indexService.queryParserService();
    }

    @Override
    public SimilarityService similarityService() {
        return this.indexService.similarityService();
    }

    @Override
    public ScriptService scriptService() {
        return this.scriptService;
    }

    @Override
    public CacheRecycler cacheRecycler() {
        return this.cacheRecycler;
    }

    @Override
    public PageCacheRecycler pageCacheRecycler() {
        return this.pageCacheRecycler;
    }

    @Override
    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    @Override
    public FilterCache filterCache() {
        return this.indexService.cache().filter();
    }

    @Override
    public FixedBitSetFilterCache fixedBitSetFilterCache() {
        return this.indexService.fixedBitSetFilterCache();
    }

    @Override
    public DocSetCache docSetCache() {
        return this.indexService.cache().docSet();
    }

    @Override
    public IndexFieldDataService fieldData() {
        return this.indexService.fieldData();
    }

    @Override
    public long timeoutInMillis() {
        return this.timeoutInMillis;
    }

    @Override
    public void timeoutInMillis(long timeoutInMillis) {
        this.timeoutInMillis = timeoutInMillis;
    }

    @Override
    public int terminateAfter() {
        return this.terminateAfter;
    }

    @Override
    public void terminateAfter(int terminateAfter) {
        this.terminateAfter = terminateAfter;
    }

    @Override
    public SearchContext minimumScore(float minimumScore) {
        this.minimumScore = Float.valueOf(minimumScore);
        return this;
    }

    @Override
    public Float minimumScore() {
        return this.minimumScore;
    }

    @Override
    public SearchContext sort(Sort sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public Sort sort() {
        return this.sort;
    }

    @Override
    public SearchContext trackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    @Override
    public boolean trackScores() {
        return this.trackScores;
    }

    @Override
    public SearchContext parsedPostFilter(ParsedFilter postFilter) {
        this.postFilter = postFilter;
        return this;
    }

    @Override
    public ParsedFilter parsedPostFilter() {
        return this.postFilter;
    }

    @Override
    public Filter aliasFilter() {
        return this.aliasFilter;
    }

    @Override
    public SearchContext parsedQuery(ParsedQuery query) {
        this.queryRewritten = false;
        this.originalQuery = query;
        this.query = query.query();
        return this;
    }

    @Override
    public ParsedQuery parsedQuery() {
        return this.originalQuery;
    }

    @Override
    public Query query() {
        return this.query;
    }

    @Override
    public boolean queryRewritten() {
        return this.queryRewritten;
    }

    @Override
    public SearchContext updateRewriteQuery(Query rewriteQuery) {
        this.query = rewriteQuery;
        this.queryRewritten = true;
        return this;
    }

    @Override
    public int from() {
        return this.from;
    }

    @Override
    public SearchContext from(int from) {
        this.from = from;
        return this;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public SearchContext size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public boolean hasFieldNames() {
        return this.fieldNames != null;
    }

    @Override
    public List<String> fieldNames() {
        if (this.fieldNames == null) {
            this.fieldNames = Lists.newArrayList();
        }
        return this.fieldNames;
    }

    @Override
    public void emptyFieldNames() {
        this.fieldNames = ImmutableList.of();
    }

    @Override
    public boolean explain() {
        return this.explain;
    }

    @Override
    public void explain(boolean explain) {
        this.explain = explain;
    }

    @Override
    @Nullable
    public List<String> groupStats() {
        return this.groupStats;
    }

    @Override
    public void groupStats(List<String> groupStats) {
        this.groupStats = groupStats;
    }

    @Override
    public boolean version() {
        return this.version;
    }

    @Override
    public void version(boolean version) {
        this.version = version;
    }

    @Override
    public int[] docIdsToLoad() {
        return this.docIdsToLoad;
    }

    @Override
    public int docIdsToLoadFrom() {
        return this.docsIdsToLoadFrom;
    }

    @Override
    public int docIdsToLoadSize() {
        return this.docsIdsToLoadSize;
    }

    @Override
    public SearchContext docIdsToLoad(int[] docIdsToLoad, int docsIdsToLoadFrom, int docsIdsToLoadSize) {
        this.docIdsToLoad = docIdsToLoad;
        this.docsIdsToLoadFrom = docsIdsToLoadFrom;
        this.docsIdsToLoadSize = docsIdsToLoadSize;
        return this;
    }

    @Override
    public void accessed(long accessTime) {
        this.lastAccessTime = accessTime;
    }

    @Override
    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long keepAlive() {
        return this.keepAlive;
    }

    @Override
    public void keepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public void lastEmittedDoc(ScoreDoc doc) {
        this.lastEmittedDoc = doc;
    }

    @Override
    public ScoreDoc lastEmittedDoc() {
        return this.lastEmittedDoc;
    }

    @Override
    public SearchLookup lookup() {
        if (this.searchLookup == null) {
            this.searchLookup = new SearchLookup(this.mapperService(), this.fieldData(), this.request.types());
        }
        return this.searchLookup;
    }

    @Override
    public DfsSearchResult dfsResult() {
        return this.dfsResult;
    }

    @Override
    public QuerySearchResult queryResult() {
        return this.queryResult;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this.fetchResult;
    }

    @Override
    public ScanContext scanContext() {
        if (this.scanContext == null) {
            this.scanContext = new ScanContext();
        }
        return this.scanContext;
    }

    @Override
    public MapperService.SmartNameFieldMappers smartFieldMappers(String name) {
        return this.mapperService().smartName(name, this.request.types());
    }

    @Override
    public FieldMappers smartNameFieldMappers(String name) {
        return this.mapperService().smartNameFieldMappers(name, this.request.types());
    }

    @Override
    public FieldMapper smartNameFieldMapper(String name) {
        return this.mapperService().smartNameFieldMapper(name, this.request.types());
    }

    @Override
    public FieldMapper smartNameFieldMapperFromAnyType(String name) {
        return this.mapperService().smartNameFieldMapper(name);
    }

    @Override
    public MapperService.SmartNameObjectMapper smartNameObjectMapper(String name) {
        return this.mapperService().smartNameObjectMapper(name, this.request.types());
    }

    @Override
    public boolean useSlowScroll() {
        return this.useSlowScroll;
    }

    @Override
    public DefaultSearchContext useSlowScroll(boolean useSlowScroll) {
        this.useSlowScroll = useSlowScroll;
        return this;
    }

    @Override
    public Counter timeEstimateCounter() {
        return this.timeEstimateCounter;
    }

    @Override
    public void innerHits(InnerHitsContext innerHitsContext) {
        this.innerHitsContext = innerHitsContext;
    }

    @Override
    public InnerHitsContext innerHits() {
        return this.innerHitsContext;
    }

    @Override
    public <V> V putInContext(Object key, Object value) {
        return this.request.putInContext(key, value);
    }

    @Override
    public void putAllInContext(ObjectObjectAssociativeContainer<Object, Object> map) {
        this.request.putAllInContext(map);
    }

    @Override
    public <V> V getFromContext(Object key) {
        return this.request.getFromContext(key);
    }

    @Override
    public <V> V getFromContext(Object key, V defaultValue) {
        return this.request.getFromContext(key, defaultValue);
    }

    @Override
    public boolean hasInContext(Object key) {
        return this.request.hasInContext(key);
    }

    @Override
    public int contextSize() {
        return this.request.contextSize();
    }

    @Override
    public boolean isContextEmpty() {
        return this.request.isContextEmpty();
    }

    @Override
    public ImmutableOpenMap<Object, Object> getContext() {
        return this.request.getContext();
    }

    @Override
    public void copyContextFrom(HasContext other) {
        this.request.copyContextFrom(other);
    }

    @Override
    public HasHeaders putHeader(String key, Object value) {
        return this.request.putHeader(key, value);
    }

    @Override
    public <V> V getHeader(String key) {
        return this.request.getHeader(key);
    }

    @Override
    public boolean hasHeader(String key) {
        return this.request.hasHeader(key);
    }

    @Override
    public Set<String> getHeaders() {
        return this.request.getHeaders();
    }

    @Override
    public void copyHeadersFrom(HasHeaders from) {
        this.request.copyHeadersFrom(from);
    }

    @Override
    public void copyContextAndHeadersFrom(HasContextAndHeaders other) {
        this.request.copyContextAndHeadersFrom(other);
    }
}

