/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.version;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.version.VersionParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class VersionFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("version", new VersionParseElement());
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.version();
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        long version;
        try {
            BytesRef uid = Uid.createUidAsBytes(hitContext.hit().type(), hitContext.hit().id());
            version = Versions.loadVersion(hitContext.readerContext().reader(), new Term("_uid", uid));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Could not query index for _version", e);
        }
        if (version < 0L) {
            version = -1L;
        }
        hitContext.hit().version(version);
    }
}

