/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch;

import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public interface FetchSubPhase {
    public Map<String, ? extends SearchParseElement> parseElements();

    public boolean hitExecutionNeeded(SearchContext var1);

    public void hitExecute(SearchContext var1, HitContext var2) throws ElasticsearchException;

    public boolean hitsExecutionNeeded(SearchContext var1);

    public void hitsExecute(SearchContext var1, InternalSearchHit[] var2) throws ElasticsearchException;

    public static class HitContext {
        private InternalSearchHit hit;
        private IndexReader topLevelReader;
        private AtomicReaderContext readerContext;
        private int docId;
        private Map<String, Object> cache;
        private IndexSearcher atomicIndexSearcher;

        public void reset(InternalSearchHit hit, AtomicReaderContext context, int docId, IndexReader topLevelReader) {
            this.hit = hit;
            this.readerContext = context;
            this.docId = docId;
            this.topLevelReader = topLevelReader;
            this.atomicIndexSearcher = null;
        }

        public InternalSearchHit hit() {
            return this.hit;
        }

        public AtomicReader reader() {
            return this.readerContext.reader();
        }

        public AtomicReaderContext readerContext() {
            return this.readerContext;
        }

        public IndexSearcher searcher() {
            if (this.atomicIndexSearcher == null) {
                this.atomicIndexSearcher = new IndexSearcher(this.readerContext.reader());
            }
            return this.atomicIndexSearcher;
        }

        public int docId() {
            return this.docId;
        }

        public IndexReader topLevelReader() {
            return this.topLevelReader;
        }

        public Map<String, Object> cache() {
            if (this.cache == null) {
                this.cache = Maps.newHashMap();
            }
            return this.cache;
        }

        public String getSourcePath(String sourcePath) {
            SearchHit.NestedIdentity nested = this.hit().getNestedIdentity();
            if (nested != null) {
                StringBuilder nestedPath = new StringBuilder();
                while (nested != null) {
                    nestedPath.append(nested.getField());
                    nested = nested.getChild();
                }
                assert (sourcePath.startsWith(nestedPath.toString()));
                int startIndex = nestedPath.length() + 1;
                return sourcePath.substring(startIndex);
            }
            return sourcePath;
        }
    }
}

