/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.range;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.FacetPhaseExecutionException;
import org.elasticsearch.search.facet.range.InternalRangeFacet;
import org.elasticsearch.search.facet.range.KeyValueRangeFacetExecutor;
import org.elasticsearch.search.facet.range.RangeFacet;
import org.elasticsearch.search.facet.range.RangeFacetExecutor;
import org.elasticsearch.search.facet.range.ScriptRangeFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class RangeFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public RangeFacetParser(Settings settings) {
        super(settings);
        InternalRangeFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"range"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String keyField = null;
        String valueField = null;
        String scriptLang = null;
        String keyScript = null;
        ScriptService.ScriptType keyScriptType = null;
        String valueScript = null;
        ScriptService.ScriptType valueScriptType = null;
        Map<String, Object> params = null;
        String fieldName = null;
        ArrayList<RangeFacet.Entry> entries = Lists.newArrayList();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (!"ranges".equals(fieldName)) {
                    keyField = fieldName;
                }
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    RangeFacet.Entry entry = new RangeFacet.Entry();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("from".equals(fieldName)) {
                                entry.fromAsString = parser.text();
                                continue;
                            }
                            if (!"to".equals(fieldName)) continue;
                            entry.toAsString = parser.text();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if ("from".equals(fieldName)) {
                            entry.from = parser.doubleValue();
                            continue;
                        }
                        if (!"to".equals(fieldName)) continue;
                        entry.to = parser.doubleValue();
                    }
                    entries.add(entry);
                }
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"params".equals(fieldName)) continue;
                params = parser.map();
                continue;
            }
            if (!token.isValue()) continue;
            if ("field".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("key_field".equals(fieldName) || "keyField".equals(fieldName)) {
                keyField = parser.text();
                continue;
            }
            if ("value_field".equals(fieldName) || "valueField".equals(fieldName)) {
                valueField = parser.text();
                continue;
            }
            if (ScriptService.KEY_SCRIPT_INLINE.match(fieldName)) {
                keyScript = parser.text();
                keyScriptType = ScriptService.ScriptType.INLINE;
                continue;
            }
            if (ScriptService.KEY_SCRIPT_ID.match(fieldName)) {
                keyScript = parser.text();
                keyScriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if (ScriptService.KEY_SCRIPT_FILE.match(fieldName)) {
                keyScript = parser.text();
                keyScriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_INLINE.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.INLINE;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_ID.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.INDEXED;
                continue;
            }
            if (ScriptService.VALUE_SCRIPT_FILE.match(fieldName)) {
                valueScript = parser.text();
                valueScriptType = ScriptService.ScriptType.FILE;
                continue;
            }
            if (!ScriptService.SCRIPT_LANG.match(fieldName)) continue;
            scriptLang = parser.text();
        }
        if (entries.isEmpty()) {
            throw new FacetPhaseExecutionException(facetName, "no ranges defined for range facet");
        }
        RangeFacet.Entry[] rangeEntries = entries.toArray(new RangeFacet.Entry[entries.size()]);
        if (keyScript != null && valueScript != null) {
            return new ScriptRangeFacetExecutor(scriptLang, keyScript, keyScriptType, valueScript, valueScriptType, params, rangeEntries, context);
        }
        if (keyField == null) {
            throw new FacetPhaseExecutionException(facetName, "key field is required to be set for range facet, either using [field] or using [key_field]");
        }
        FieldMapper keyFieldMapper = context.smartNameFieldMapper(keyField);
        if (keyFieldMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for key_field [" + keyField + "]");
        }
        for (RangeFacet.Entry entry : rangeEntries) {
            if (entry.fromAsString != null) {
                entry.from = ((Number)keyFieldMapper.value(entry.fromAsString)).doubleValue();
            }
            if (entry.toAsString == null) continue;
            entry.to = ((Number)keyFieldMapper.value(entry.toAsString)).doubleValue();
        }
        IndexNumericFieldData keyIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(keyFieldMapper);
        if (valueField == null || keyField.equals(valueField)) {
            return new RangeFacetExecutor(keyIndexFieldData, rangeEntries, context);
        }
        FieldMapper valueFieldMapper = context.smartNameFieldMapper(valueField);
        if (valueFieldMapper == null) {
            throw new FacetPhaseExecutionException(facetName, "No mapping found for value_field [" + valueField + "]");
        }
        IndexNumericFieldData valueIndexFieldData = (IndexNumericFieldData)context.fieldData().getForField(valueFieldMapper);
        return new KeyValueRangeFacetExecutor(keyIndexFieldData, valueIndexFieldData, rangeEntries, context);
    }
}

