/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.query;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.FacetParser;
import org.elasticsearch.search.facet.query.InternalQueryFacet;
import org.elasticsearch.search.facet.query.QueryFacetExecutor;
import org.elasticsearch.search.internal.SearchContext;

public class QueryFacetParser
extends AbstractComponent
implements FacetParser {
    @Inject
    public QueryFacetParser(Settings settings) {
        super(settings);
        InternalQueryFacet.registerStreams();
    }

    @Override
    public String[] types() {
        return new String[]{"query"};
    }

    @Override
    public FacetExecutor.Mode defaultMainMode() {
        return FacetExecutor.Mode.COLLECTOR;
    }

    @Override
    public FacetExecutor.Mode defaultGlobalMode() {
        return FacetExecutor.Mode.POST;
    }

    @Override
    public FacetExecutor parse(String facetName, XContentParser parser, SearchContext context) throws IOException {
        Query facetQuery = context.queryParserService().parse(parser).query();
        return new QueryFacetExecutor(facetQuery);
    }
}

