/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.filter;

import java.io.IOException;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.docset.AndDocIdSet;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.filter.InternalFilterFacet;

public class FilterFacetExecutor
extends FacetExecutor {
    private final Filter filter;
    long count = -1L;

    public FilterFacetExecutor(Filter filter) {
        this.filter = filter;
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public Post post() {
        return new Post();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return new InternalFilterFacet(facetName, this.count);
    }

    class Collector
    extends FacetExecutor.Collector {
        private long count = 0L;
        private Bits bits;

        Collector() {
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.bits.get(doc)) {
                ++this.count;
            }
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.bits = DocIdSets.toSafeBits(context.reader(), FilterFacetExecutor.this.filter.getDocIdSet(context, context.reader().getLiveDocs()));
        }

        @Override
        public void postCollection() {
            this.bits = null;
            FilterFacetExecutor.this.count = this.count;
        }
    }

    class Post
    extends FacetExecutor.Post {
        Post() {
        }

        @Override
        public void executePost(List<ContextDocIdSet> docSets) throws IOException {
            int count = 0;
            for (ContextDocIdSet docSet : docSets) {
                DocIdSet filteredDocIdSet = FilterFacetExecutor.this.filter.getDocIdSet(docSet.context, docSet.context.reader().getLiveDocs());
                if (filteredDocIdSet == null || docSet.docSet == null) continue;
                DocIdSetIterator iter = new AndDocIdSet(new DocIdSet[]{docSet.docSet, filteredDocIdSet}).iterator();
                while (iter.nextDoc() != Integer.MAX_VALUE) {
                    ++count;
                }
            }
            FilterFacetExecutor.this.count = count;
        }
    }
}

