/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import org.elasticsearch.index.fielddata.SortingBinaryDocValues;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.aggregations.support.ScriptValues;

public class ScriptBytesValues
extends SortingBinaryDocValues
implements ScriptValues {
    private final SearchScript script;

    public ScriptBytesValues(SearchScript script) {
        this.script = script;
    }

    @Override
    public SearchScript script() {
        return this.script;
    }

    private void set(int i, Object o) {
        if (o == null) {
            this.values[i].clear();
        } else {
            this.values[i].copyChars(o.toString());
        }
    }

    @Override
    public void setDocument(int docId) {
        this.script.setNextDocId(docId);
        Object value = this.script.run();
        if (value == null) {
            this.count = 0;
        } else if (value.getClass().isArray()) {
            this.count = Array.getLength(value);
            this.grow();
            for (int i = 0; i < this.count; ++i) {
                this.set(i, Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            Collection coll = (Collection)value;
            this.count = coll.size();
            this.grow();
            int i = 0;
            for (Object v : coll) {
                this.set(i++, v);
            }
        } else {
            this.count = 1;
            this.set(0, value);
        }
        this.sort();
    }
}

