/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.stats.extended;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.stats.extended.InternalExtendedStats;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class ExtendedStatsAggregator
extends NumericMetricsAggregator.MultiValue {
    private final ValuesSource.Numeric valuesSource;
    private SortedNumericDoubleValues values;
    private LongArray counts;
    private DoubleArray sums;
    private DoubleArray mins;
    private DoubleArray maxes;
    private DoubleArray sumOfSqrs;
    private ValueFormatter formatter;
    private double sigma;

    public ExtendedStatsAggregator(String name, long estimatedBucketsCount, ValuesSource.Numeric valuesSource, @Nullable ValueFormatter formatter, AggregationContext context, Aggregator parent, double sigma) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            long initialSize = estimatedBucketsCount < 2L ? 1L : estimatedBucketsCount;
            this.counts = this.bigArrays.newLongArray(initialSize, true);
            this.sums = this.bigArrays.newDoubleArray(initialSize, true);
            this.mins = this.bigArrays.newDoubleArray(initialSize, false);
            this.mins.fill(0L, this.mins.size(), Double.POSITIVE_INFINITY);
            this.maxes = this.bigArrays.newDoubleArray(initialSize, false);
            this.maxes.fill(0L, this.maxes.size(), Double.NEGATIVE_INFINITY);
            this.sumOfSqrs = this.bigArrays.newDoubleArray(initialSize, true);
            this.sigma = sigma;
        }
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.doubleValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        if (owningBucketOrdinal >= this.counts.size()) {
            long from = this.counts.size();
            long overSize = BigArrays.overSize(owningBucketOrdinal + 1L);
            this.counts = this.bigArrays.resize(this.counts, overSize);
            this.sums = this.bigArrays.resize(this.sums, overSize);
            this.mins = this.bigArrays.resize(this.mins, overSize);
            this.maxes = this.bigArrays.resize(this.maxes, overSize);
            this.sumOfSqrs = this.bigArrays.resize(this.sumOfSqrs, overSize);
            this.mins.fill(from, overSize, Double.POSITIVE_INFINITY);
            this.maxes.fill(from, overSize, Double.NEGATIVE_INFINITY);
        }
        this.values.setDocument(doc);
        int valuesCount = this.values.count();
        this.counts.increment(owningBucketOrdinal, valuesCount);
        double sum = 0.0;
        double sumOfSqr = 0.0;
        double min = this.mins.get(owningBucketOrdinal);
        double max = this.maxes.get(owningBucketOrdinal);
        for (int i = 0; i < valuesCount; ++i) {
            double value = this.values.valueAt(i);
            sum += value;
            sumOfSqr += value * value;
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        this.sums.increment(owningBucketOrdinal, sum);
        this.sumOfSqrs.increment(owningBucketOrdinal, sumOfSqr);
        this.mins.set(owningBucketOrdinal, min);
        this.maxes.set(owningBucketOrdinal, max);
    }

    @Override
    public boolean hasMetric(String name) {
        try {
            InternalExtendedStats.Metrics.resolve(name);
            return true;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public double metric(String name, long owningBucketOrd) {
        switch (InternalExtendedStats.Metrics.resolve(name)) {
            case count: {
                return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
            }
            case sum: {
                return this.valuesSource == null ? 0.0 : this.sums.get(owningBucketOrd);
            }
            case min: {
                return this.valuesSource == null ? Double.POSITIVE_INFINITY : this.mins.get(owningBucketOrd);
            }
            case max: {
                return this.valuesSource == null ? Double.NEGATIVE_INFINITY : this.maxes.get(owningBucketOrd);
            }
            case avg: {
                return this.valuesSource == null ? Double.NaN : this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
            }
            case sum_of_squares: {
                return this.valuesSource == null ? 0.0 : this.sumOfSqrs.get(owningBucketOrd);
            }
            case variance: {
                return this.valuesSource == null ? Double.NaN : this.variance(owningBucketOrd);
            }
            case std_deviation: {
                return this.valuesSource == null ? Double.NaN : Math.sqrt(this.variance(owningBucketOrd));
            }
            case std_upper: {
                if (this.valuesSource == null) {
                    return Double.NaN;
                }
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) + Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
            case std_lower: {
                if (this.valuesSource == null) {
                    return Double.NaN;
                }
                return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd) - Math.sqrt(this.variance(owningBucketOrd)) * this.sigma;
            }
        }
        throw new ElasticsearchIllegalArgumentException("Unknown value [" + name + "] in common stats aggregation");
    }

    private double variance(long owningBucketOrd) {
        double sum = this.sums.get(owningBucketOrd);
        long count = this.counts.get(owningBucketOrd);
        return (this.sumOfSqrs.get(owningBucketOrd) - sum * sum / (double)count) / (double)count;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.valuesSource == null) {
            return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, 0.0, this.formatter);
        }
        assert (owningBucketOrdinal < this.counts.size());
        return new InternalExtendedStats(this.name, this.counts.get(owningBucketOrdinal), this.sums.get(owningBucketOrdinal), this.mins.get(owningBucketOrdinal), this.maxes.get(owningBucketOrdinal), this.sumOfSqrs.get(owningBucketOrdinal), this.sigma, this.formatter);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalExtendedStats(this.name, 0L, 0.0, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0, 0.0, this.formatter);
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts, this.maxes, this.mins, this.sumOfSqrs, this.sums);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory.LeafOnly<ValuesSource.Numeric> {
        private final double sigma;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Numeric> valuesSourceConfig, double sigma) {
            super(name, InternalExtendedStats.TYPE.name(), valuesSourceConfig);
            this.sigma = sigma;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new ExtendedStatsAggregator(this.name, 0L, null, this.config.formatter(), aggregationContext, parent, this.sigma);
        }

        @Override
        protected Aggregator create(ValuesSource.Numeric valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            return new ExtendedStatsAggregator(this.name, expectedBucketsCount, valuesSource, this.config.formatter(), aggregationContext, parent, this.sigma);
        }
    }
}

