/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.scripted.InternalScriptedMetric;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.internal.SearchContext;

public class ScriptedMetricAggregator
extends MetricsAggregator {
    private final String scriptLang;
    private final SearchScript mapScript;
    private final ExecutableScript combineScript;
    private final String reduceScript;
    private final Map<String, Object> params;
    private final Map<String, Object> reduceParams;
    private final ScriptService.ScriptType reduceScriptType;

    protected ScriptedMetricAggregator(String name, String scriptLang, ScriptService.ScriptType initScriptType, String initScript, ScriptService.ScriptType mapScriptType, String mapScript, ScriptService.ScriptType combineScriptType, String combineScript, ScriptService.ScriptType reduceScriptType, String reduceScript, Map<String, Object> params, Map<String, Object> reduceParams, AggregationContext context, Aggregator parent) {
        super(name, 1L, Aggregator.BucketAggregationMode.PER_BUCKET, context, parent);
        this.scriptLang = scriptLang;
        this.reduceScriptType = reduceScriptType;
        if (params == null) {
            this.params = new HashMap<String, Object>();
            this.params.put("_agg", new HashMap());
        } else {
            this.params = new HashMap<String, Object>(params);
        }
        this.reduceParams = reduceParams == null ? new HashMap<String, Object>() : reduceParams;
        ScriptService scriptService = context.searchContext().scriptService();
        if (initScript != null) {
            scriptService.executable(scriptLang, initScript, initScriptType, ScriptContext.Standard.AGGS, this.params).run();
        }
        this.mapScript = scriptService.search(context.searchContext().lookup(), scriptLang, mapScript, mapScriptType, ScriptContext.Standard.AGGS, this.params);
        this.combineScript = combineScript != null ? scriptService.executable(scriptLang, combineScript, combineScriptType, ScriptContext.Standard.AGGS, this.params) : null;
        this.reduceScript = reduceScript;
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.mapScript.setNextReader(reader);
    }

    @Override
    public void collect(int docId, long bucketOrdinal) throws IOException {
        this.mapScript.setNextDocId(docId);
        this.mapScript.run();
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        Object aggregation = this.combineScript != null ? this.combineScript.run() : this.params.get("_agg");
        return new InternalScriptedMetric(this.name, aggregation, this.scriptLang, this.reduceScriptType, this.reduceScript, this.reduceParams);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalScriptedMetric(this.name, null, this.scriptLang, this.reduceScriptType, this.reduceScript, this.reduceParams);
    }

    public static class Factory
    extends AggregatorFactory {
        private String scriptLang;
        private ScriptService.ScriptType initScriptType;
        private ScriptService.ScriptType mapScriptType;
        private ScriptService.ScriptType combineScriptType;
        private ScriptService.ScriptType reduceScriptType;
        private String initScript;
        private String mapScript;
        private String combineScript;
        private String reduceScript;
        private Map<String, Object> params;
        private Map<String, Object> reduceParams;

        public Factory(String name, String scriptLang, ScriptService.ScriptType initScriptType, String initScript, ScriptService.ScriptType mapScriptType, String mapScript, ScriptService.ScriptType combineScriptType, String combineScript, ScriptService.ScriptType reduceScriptType, String reduceScript, Map<String, Object> params, Map<String, Object> reduceParams) {
            super(name, InternalScriptedMetric.TYPE.name());
            this.scriptLang = scriptLang;
            this.initScriptType = initScriptType;
            this.mapScriptType = mapScriptType;
            this.combineScriptType = combineScriptType;
            this.reduceScriptType = reduceScriptType;
            this.initScript = initScript;
            this.mapScript = mapScript;
            this.combineScript = combineScript;
            this.reduceScript = reduceScript;
            this.params = params;
            this.reduceParams = reduceParams;
        }

        @Override
        public Aggregator create(AggregationContext context, Aggregator parent, long expectedBucketsCount) {
            Map<String, Object> params = null;
            if (this.params != null) {
                params = Factory.deepCopyParams(this.params, context.searchContext());
            }
            Map<String, Object> reduceParams = null;
            if (this.reduceParams != null) {
                reduceParams = Factory.deepCopyParams(this.reduceParams, context.searchContext());
            }
            return new ScriptedMetricAggregator(this.name, this.scriptLang, this.initScriptType, this.initScript, this.mapScriptType, this.mapScript, this.combineScriptType, this.combineScript, this.reduceScriptType, this.reduceScript, params, reduceParams, context, parent);
        }

        private static <T> T deepCopyParams(T original, SearchContext context) {
            Object clone;
            if (original instanceof Map) {
                Map originalMap = (Map)original;
                HashMap clonedMap = new HashMap();
                for (Map.Entry e : originalMap.entrySet()) {
                    clonedMap.put(Factory.deepCopyParams(e.getKey(), context), Factory.deepCopyParams(e.getValue(), context));
                }
                clone = clonedMap;
            } else if (original instanceof List) {
                List originalList = (List)original;
                ArrayList clonedList = new ArrayList();
                for (Object o : originalList) {
                    clonedList.add(Factory.deepCopyParams(o, context));
                }
                clone = clonedList;
            } else if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Short || original instanceof Byte || original instanceof Float || original instanceof Double || original instanceof Character || original instanceof Boolean) {
                clone = original;
            } else {
                throw new SearchParseException(context, "Can only clone primitives, String, ArrayList, and HashMap. Found: " + original.getClass().getCanonicalName());
            }
            return clone;
        }
    }
}

