/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BytesRefHash;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class StringTermsAggregator
extends AbstractStringTermsAggregator {
    private final ValuesSource valuesSource;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude includeExclude;
    private SortedBinaryDocValues values;
    private final BytesRefBuilder previous;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError) {
        super(name, factories, estimatedBucketCount, aggregationContext, parent, order, bucketCountThresholds, collectionMode, showTermDocCountError);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(estimatedBucketCount, aggregationContext.bigArrays());
        this.previous = new BytesRefBuilder();
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.valuesSource.bytesValues();
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.values.setDocument(doc);
        int valuesCount = this.values.count();
        this.previous.clear();
        for (int i = 0; i < valuesCount; ++i) {
            BytesRef bytes = this.values.valueAt(i);
            if (this.includeExclude != null && !this.includeExclude.accept(bytes) || this.previous.get().equals(bytes)) continue;
            long bucketOrdinal = this.bucketOrds.add(bytes);
            if (bucketOrdinal < 0L) {
                bucketOrdinal = -1L - bucketOrdinal;
                this.collectExistingBucket(doc, bucketOrdinal);
            } else {
                this.collectBucket(doc, bucketOrdinal);
            }
            this.previous.copyBytes(bytes);
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        StringTerms.Bucket bucket;
        int i;
        int i2;
        assert (owningBucketOrdinal == 0L);
        if (this.bucketCountThresholds.getMinDocCount() == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.bucketCountThresholds.getRequiredSize())) {
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                SortedBinaryDocValues values = this.valuesSource.bytesValues();
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    values.setDocument(docId);
                    int valueCount = values.count();
                    for (i2 = 0; i2 < valueCount; ++i2) {
                        BytesRef term = values.valueAt(i2);
                        if (this.includeExclude != null && !this.includeExclude.accept(term)) continue;
                        this.bucketOrds.add(term);
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        StringTerms.Bucket spare = null;
        i2 = 0;
        while ((long)i2 < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null, this.showTermDocCountError, 0L);
            }
            this.bucketOrds.get(i2, spare.termBytes);
            spare.docCount = this.bucketDocCount(i2);
            otherDocCount += spare.docCount;
            spare.bucketOrd = i2;
            if (this.bucketCountThresholds.getShardMinDocCount() <= spare.docCount) {
                spare = ordered.insertWithOverflow(spare);
            }
            ++i2;
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
            otherDocCount -= bucket.docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = (StringTerms.Bucket)list[i];
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            bucket.docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list), this.showTermDocCountError, 0L, otherDocCount);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

