/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.LongBitSet;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.AbstractRandomAccessOrds;
import org.elasticsearch.index.fielddata.ordinals.GlobalOrdinalMapping;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class GlobalOrdinalsStringTermsAggregator
extends AbstractStringTermsAggregator {
    protected final ValuesSource.Bytes.WithOrdinals.FieldData valuesSource;
    protected final IncludeExclude includeExclude;
    protected RandomAccessOrds globalOrds;
    protected LongBitSet acceptedGlobalOrdinals;
    protected Collector collector;

    public GlobalOrdinalsStringTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError) {
        super(name, factories, maxOrd, aggregationContext, parent, order, bucketCountThresholds, collectionMode, showTermDocCountError);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
    }

    protected long getBucketOrd(long termOrd) {
        return termOrd;
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    protected Collector newCollector(final RandomAccessOrds ords) {
        final SortedDocValues singleValues = DocValues.unwrapSingleton(ords);
        if (singleValues != null) {
            return new Collector(){

                @Override
                public void collect(int doc) throws IOException {
                    int ord = singleValues.getOrd(doc);
                    if (ord >= 0) {
                        GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(doc, ord);
                    }
                }
            };
        }
        return new Collector(){

            @Override
            public void collect(int doc) throws IOException {
                ords.setDocument(doc);
                int numOrds = ords.cardinality();
                for (int i = 0; i < numOrds; ++i) {
                    long globalOrd = ords.ordAt(i);
                    GlobalOrdinalsStringTermsAggregator.this.collectExistingBucket(doc, globalOrd);
                }
            }
        };
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.globalOrds = this.valuesSource.globalOrdinalsValues();
        if (this.acceptedGlobalOrdinals != null) {
            this.globalOrds = new FilteredOrdinals(this.globalOrds, this.acceptedGlobalOrdinals);
        } else if (this.includeExclude != null) {
            this.acceptedGlobalOrdinals = this.includeExclude.acceptedGlobalOrdinals(this.globalOrds, this.valuesSource);
            this.globalOrds = new FilteredOrdinals(this.globalOrds, this.acceptedGlobalOrdinals);
        }
        this.collector = this.newCollector(this.globalOrds);
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.collector.collect(doc);
    }

    protected static void copy(BytesRef from, BytesRef to) {
        if (to.bytes.length < from.length) {
            to.bytes = new byte[ArrayUtil.oversize(from.length, 1)];
        }
        to.offset = 0;
        to.length = from.length;
        System.arraycopy(from.bytes, from.offset, to.bytes, 0, from.length);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        InternalTerms.Bucket bucket;
        int i;
        if (this.globalOrds == null) {
            return this.buildEmptyAggregation();
        }
        int size = this.bucketCountThresholds.getMinDocCount() == 0L ? (int)Math.min(this.globalOrds.getValueCount(), (long)this.bucketCountThresholds.getShardSize()) : (int)Math.min(this.maxBucketOrd(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        OrdBucket spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        for (long globalTermOrd = 0L; globalTermOrd < this.globalOrds.getValueCount(); ++globalTermOrd) {
            int bucketDocCount;
            if (this.includeExclude != null && !this.acceptedGlobalOrdinals.get(globalTermOrd)) continue;
            long bucketOrd = this.getBucketOrd(globalTermOrd);
            int n = bucketDocCount = bucketOrd < 0L ? 0 : this.bucketDocCount(bucketOrd);
            if (this.bucketCountThresholds.getMinDocCount() > 0L && bucketDocCount == 0) continue;
            otherDocCount += (long)bucketDocCount;
            spare.globalOrd = globalTermOrd;
            spare.bucketOrd = bucketOrd;
            spare.docCount = bucketDocCount;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount || (spare = ordered.insertWithOverflow(spare)) != null) continue;
            spare = new OrdBucket(-1L, 0L, null, this.showTermDocCountError, 0L);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (OrdBucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            BytesRef scratch = new BytesRef();
            GlobalOrdinalsStringTermsAggregator.copy(this.globalOrds.lookupOrd(bucket.globalOrd), scratch);
            list[i] = new StringTerms.Bucket(scratch, bucket.docCount, null, this.showTermDocCountError, 0L);
            list[i].bucketOrd = bucket.bucketOrd;
            otherDocCount -= list[i].docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            bucket.aggregations = bucket.docCount == 0L ? this.bucketEmptyAggregations() : this.bucketAggregations(bucket.bucketOrd);
            bucket.docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list), this.showTermDocCountError, 0L, otherDocCount);
    }

    private static final class FilteredOrdinals
    extends AbstractRandomAccessOrds {
        private final RandomAccessOrds inner;
        private final LongBitSet accepted;
        private int cardinality;
        private long[] ords = new long[0];

        private FilteredOrdinals(RandomAccessOrds inner, LongBitSet accepted) {
            this.inner = inner;
            this.accepted = accepted;
        }

        @Override
        public long getValueCount() {
            return this.inner.getValueCount();
        }

        @Override
        public long ordAt(int index) {
            return this.ords[index];
        }

        @Override
        public void doSetDocument(int docId) {
            this.inner.setDocument(docId);
            int innerCardinality = this.inner.cardinality();
            this.ords = ArrayUtil.grow(this.ords, innerCardinality);
            this.cardinality = 0;
            for (int slot = 0; slot < innerCardinality; ++slot) {
                long ord = this.inner.ordAt(slot);
                if (!this.accepted.get(ord)) continue;
                this.ords[this.cardinality++] = ord;
            }
        }

        @Override
        public int cardinality() {
            return this.cardinality;
        }

        @Override
        public BytesRef lookupOrd(long ord) {
            return this.inner.lookupOrd(ord);
        }
    }

    public static class LowCardinality
    extends GlobalOrdinalsStringTermsAggregator {
        private final IntArray segmentDocCounts;
        private RandomAccessOrds segmentOrds;

        public LowCardinality(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError) {
            super(name, factories, valuesSource, estimatedBucketCount, maxOrd, order, bucketCountThresholds, null, aggregationContext, parent, collectionMode, showTermDocCountError);
            assert (factories == null || factories.count() == 0);
            this.segmentDocCounts = this.bigArrays.newIntArray(maxOrd + 1L, true);
        }

        @Override
        protected Collector newCollector(RandomAccessOrds ords) {
            final SortedDocValues singleValues = DocValues.unwrapSingleton(this.segmentOrds);
            if (singleValues != null) {
                return new Collector(){

                    @Override
                    public void collect(int doc) throws IOException {
                        int ord = singleValues.getOrd(doc);
                        LowCardinality.this.segmentDocCounts.increment(ord + 1, 1);
                    }
                };
            }
            return new Collector(){

                @Override
                public void collect(int doc) throws IOException {
                    LowCardinality.this.segmentOrds.setDocument(doc);
                    int numOrds = LowCardinality.this.segmentOrds.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long segmentOrd = LowCardinality.this.segmentOrds.ordAt(i);
                        LowCardinality.this.segmentDocCounts.increment(segmentOrd + 1L, 1);
                    }
                }
            };
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
            if (this.segmentOrds != null) {
                this.mapSegmentCountsToGlobalCounts();
            }
            this.globalOrds = this.valuesSource.globalOrdinalsValues();
            this.segmentOrds = this.valuesSource.ordinalsValues();
            this.collector = this.newCollector(this.segmentOrds);
        }

        @Override
        protected void doPostCollection() {
            if (this.segmentOrds != null) {
                this.mapSegmentCountsToGlobalCounts();
            }
        }

        @Override
        protected void doClose() {
            Releasables.close(this.segmentDocCounts);
        }

        private void mapSegmentCountsToGlobalCounts() {
            GlobalOrdinalMapping mapping;
            if (this.globalOrds instanceof GlobalOrdinalMapping) {
                mapping = (GlobalOrdinalMapping)this.globalOrds;
            } else {
                assert (this.globalOrds.getValueCount() == this.segmentOrds.getValueCount());
                mapping = null;
            }
            for (long i = 1L; i < this.segmentDocCounts.size(); ++i) {
                int inc = this.segmentDocCounts.set(i, 0);
                if (inc == 0) continue;
                long ord = i - 1L;
                long globalOrd = mapping == null ? ord : mapping.getGlobalOrd(ord);
                try {
                    this.incrementBucketDocCount(globalOrd, inc);
                    continue;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToElastic(e);
                }
            }
        }
    }

    public static class WithHash
    extends GlobalOrdinalsStringTermsAggregator {
        private final LongHash bucketOrds;

        public WithHash(String name, AggregatorFactories factories, ValuesSource.Bytes.WithOrdinals.FieldData valuesSource, long estimatedBucketCount, long maxOrd, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError) {
            super(name, factories, valuesSource, estimatedBucketCount, estimatedBucketCount, order, bucketCountThresholds, includeExclude, aggregationContext, parent, collectionMode, showTermDocCountError);
            this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
        }

        @Override
        protected Collector newCollector(final RandomAccessOrds ords) {
            final SortedDocValues singleValues = DocValues.unwrapSingleton(ords);
            if (singleValues != null) {
                return new Collector(){

                    @Override
                    public void collect(int doc) throws IOException {
                        int globalOrd = singleValues.getOrd(doc);
                        if (globalOrd >= 0) {
                            long bucketOrd = WithHash.this.bucketOrds.add(globalOrd);
                            if (bucketOrd < 0L) {
                                bucketOrd = -1L - bucketOrd;
                                WithHash.this.collectExistingBucket(doc, bucketOrd);
                            } else {
                                WithHash.this.collectBucket(doc, bucketOrd);
                            }
                        }
                    }
                };
            }
            return new Collector(){

                @Override
                public void collect(int doc) throws IOException {
                    ords.setDocument(doc);
                    int numOrds = ords.cardinality();
                    for (int i = 0; i < numOrds; ++i) {
                        long globalOrd = ords.ordAt(i);
                        long bucketOrd = WithHash.this.bucketOrds.add(globalOrd);
                        if (bucketOrd < 0L) {
                            bucketOrd = -1L - bucketOrd;
                            WithHash.this.collectExistingBucket(doc, bucketOrd);
                            continue;
                        }
                        WithHash.this.collectBucket(doc, bucketOrd);
                    }
                }
            };
        }

        @Override
        protected long getBucketOrd(long termOrd) {
            return this.bucketOrds.find(termOrd);
        }

        @Override
        protected void doClose() {
            Releasables.close(this.bucketOrds);
        }
    }

    private static interface Collector {
        public void collect(int var1) throws IOException;
    }

    static class OrdBucket
    extends InternalTerms.Bucket {
        long globalOrd;

        OrdBucket(long globalOrd, long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError) {
            super(docCount, aggregations, showDocCountError, docCountError);
            this.globalOrd = globalOrd;
        }

        @Override
        int compareTerm(Terms.Bucket other) {
            return Long.compare(this.globalOrd, ((OrdBucket)other).globalOrd);
        }

        @Override
        public String getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getKeyAsText() {
            throw new UnsupportedOperationException();
        }

        @Override
        Object getKeyAsObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        InternalTerms.Bucket newBucket(long docCount, InternalAggregations aggs, long docCountError) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Number getKeyAsNumber() {
            throw new UnsupportedOperationException();
        }
    }
}

