/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;

public class DoubleTermsAggregator
extends LongTermsAggregator {
    public DoubleTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, @Nullable ValueFormat format, long estimatedBucketCount, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, IncludeExclude.LongFilter longFilter) {
        super(name, factories, valuesSource, format, estimatedBucketCount, order, bucketCountThresholds, aggregationContext, parent, collectionMode, showTermDocCountError, longFilter);
    }

    @Override
    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource) {
        return FieldData.toSortableLongBits(valuesSource.doubleValues());
    }

    @Override
    public DoubleTerms buildAggregation(long owningBucketOrdinal) {
        LongTerms terms = (LongTerms)super.buildAggregation(owningBucketOrdinal);
        return DoubleTermsAggregator.convertToDouble(terms);
    }

    @Override
    public DoubleTerms buildEmptyAggregation() {
        LongTerms terms = (LongTerms)super.buildEmptyAggregation();
        return DoubleTermsAggregator.convertToDouble(terms);
    }

    private static DoubleTerms.Bucket convertToDouble(InternalTerms.Bucket bucket) {
        long term = bucket.getKeyAsNumber().longValue();
        double value = NumericUtils.sortableLongToDouble(term);
        return new DoubleTerms.Bucket(value, bucket.docCount, bucket.aggregations, bucket.showDocCountError, bucket.docCountError);
    }

    private static DoubleTerms convertToDouble(LongTerms terms) {
        InternalTerms.Bucket[] buckets = terms.getBuckets().toArray(new InternalTerms.Bucket[0]);
        for (int i = 0; i < buckets.length; ++i) {
            buckets[i] = DoubleTermsAggregator.convertToDouble(buckets[i]);
        }
        return new DoubleTerms(terms.getName(), terms.order, terms.formatter, terms.requiredSize, terms.shardSize, terms.minDocCount, Arrays.asList(buckets), terms.showTermDocCountError, terms.docCountError, terms.otherDocCount);
    }
}

