/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParser;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristicParserMapper;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsParametersParser
extends AbstractTermsParametersParser {
    private static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(3L, 0L, 10, -1);
    private final SignificanceHeuristicParserMapper significanceHeuristicParserMapper;
    private Filter filter = null;
    private SignificanceHeuristic significanceHeuristic;
    static final ParseField BACKGROUND_FILTER = new ParseField("background_filter", new String[0]);

    public SignificantTermsParametersParser(SignificanceHeuristicParserMapper significanceHeuristicParserMapper) {
        this.significanceHeuristicParserMapper = significanceHeuristicParserMapper;
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseSpecial(String aggregationName, XContentParser parser, SearchContext context, XContentParser.Token token, String currentFieldName) throws IOException {
        if (token != XContentParser.Token.START_OBJECT) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
        SignificanceHeuristicParser significanceHeuristicParser = this.significanceHeuristicParserMapper.get(currentFieldName);
        if (significanceHeuristicParser != null) {
            this.significanceHeuristic = significanceHeuristicParser.parse(parser);
            return;
        } else {
            if (!BACKGROUND_FILTER.match(currentFieldName)) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            this.filter = context.queryParserService().parseInnerFilter(parser).filter();
        }
    }

    public SignificanceHeuristic getSignificanceHeuristic() {
        return this.significanceHeuristic;
    }
}

