/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lucene.index.FilterableTermsEnum;
import org.elasticsearch.common.lucene.index.FreqTermsEnum;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.GlobalOrdinalsSignificantTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantLongTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.significant.UnmappedSignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.ContextIndexSearcher;
import org.elasticsearch.search.internal.SearchContext;

public class SignificantTermsAggregatorFactory
extends ValuesSourceAggregatorFactory
implements Releasable {
    private final IncludeExclude includeExclude;
    private final String executionHint;
    private String indexedFieldName;
    private FieldMapper mapper;
    private FilterableTermsEnum termsEnum;
    private int numberOfAggregatorsCreated = 0;
    private Filter filter;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final SignificanceHeuristic significanceHeuristic;

    public SignificanceHeuristic getSignificanceHeuristic() {
        return this.significanceHeuristic;
    }

    protected TermsAggregator.BucketCountThresholds getBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(this.bucketCountThresholds);
    }

    public SignificantTermsAggregatorFactory(String name, ValuesSourceConfig valueSourceConfig, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, String executionHint, Filter filter, SignificanceHeuristic significanceHeuristic) {
        super(name, SignificantStringTerms.TYPE.name(), valueSourceConfig);
        this.bucketCountThresholds = bucketCountThresholds;
        this.includeExclude = includeExclude;
        this.executionHint = executionHint;
        this.significanceHeuristic = significanceHeuristic;
        if (!valueSourceConfig.unmapped()) {
            this.indexedFieldName = this.config.fieldContext().field();
            this.mapper = SearchContext.current().smartNameFieldMapper(this.indexedFieldName);
        }
        this.filter = filter;
    }

    @Override
    protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
        final UnmappedSignificantTerms aggregation = new UnmappedSignificantTerms(this.name, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount());
        return new NonCollectingAggregator(this.name, aggregationContext, parent){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }

    protected Aggregator create(ValuesSource valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
        ++this.numberOfAggregatorsCreated;
        long estimatedBucketCount = TermsAggregatorFactory.estimatedBucketCount(valuesSource, parent);
        if (valuesSource instanceof ValuesSource.Bytes) {
            ExecutionMode execution = null;
            if (this.executionHint != null) {
                execution = ExecutionMode.fromString(this.executionHint);
            }
            if (!(valuesSource instanceof ValuesSource.Bytes.WithOrdinals)) {
                execution = ExecutionMode.MAP;
            }
            if (execution == null) {
                execution = Aggregator.hasParentBucketAggregator(parent) ? ExecutionMode.GLOBAL_ORDINALS_HASH : ExecutionMode.GLOBAL_ORDINALS;
            }
            assert (execution != null);
            valuesSource.setNeedsGlobalOrdinals(execution.needsGlobalOrdinals());
            return execution.create(this.name, this.factories, valuesSource, estimatedBucketCount, this.bucketCountThresholds, this.includeExclude, aggregationContext, parent, this);
        }
        if (this.includeExclude != null && this.includeExclude.isRegexBased()) {
            throw new AggregationExecutionException("Aggregation [" + this.name + "] cannot support regular expression style include/exclude " + "settings as they can only be applied to string fields. Use an array of numeric values for include/exclude clauses used to filter numeric fields");
        }
        if (valuesSource instanceof ValuesSource.Numeric) {
            if (((ValuesSource.Numeric)valuesSource).isFloatingPoint()) {
                throw new UnsupportedOperationException("No support for examining floating point numerics");
            }
            IncludeExclude.LongFilter longFilter = null;
            if (this.includeExclude != null) {
                longFilter = this.includeExclude.convertToLongFilter();
            }
            return new SignificantLongTermsAggregator(this.name, this.factories, (ValuesSource.Numeric)valuesSource, this.config.format(), estimatedBucketCount, this.bucketCountThresholds, aggregationContext, parent, this, longFilter);
        }
        throw new AggregationExecutionException("sigfnificant_terms aggregation cannot be applied to field [" + this.config.fieldContext().field() + "]. It can only be applied to numeric or string fields.");
    }

    public long prepareBackground(AggregationContext context) {
        if (this.termsEnum != null) {
            return this.termsEnum.getNumDocs();
        }
        SearchContext searchContext = context.searchContext();
        IndexReader reader = searchContext.searcher().getIndexReader();
        try {
            this.termsEnum = this.numberOfAggregatorsCreated == 1 ? new FilterableTermsEnum(reader, this.indexedFieldName, 0, this.filter) : new FreqTermsEnum(reader, this.indexedFieldName, true, false, this.filter, searchContext.bigArrays());
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to build terms enumeration", e);
        }
        return this.termsEnum.getNumDocs();
    }

    public long getBackgroundFrequency(BytesRef termBytes) {
        assert (this.termsEnum != null);
        long result = 0L;
        try {
            if (this.termsEnum.seekExact(termBytes)) {
                result = this.termsEnum.docFreq();
            }
        }
        catch (IOException e) {
            throw new ElasticsearchException("IOException loading background document frequency info", e);
        }
        return result;
    }

    public long getBackgroundFrequency(long term) {
        BytesRef indexedVal = this.mapper.indexedValueForSearch(term);
        return this.getBackgroundFrequency(indexedVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ElasticsearchException {
        try {
            if (this.termsEnum instanceof Releasable) {
                ((Releasable)((Object)this.termsEnum)).close();
            }
        }
        finally {
            this.termsEnum = null;
        }
    }

    public static enum ExecutionMode {
        MAP(new ParseField("map", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggregatorFactory) {
                return new SignificantStringTermsAggregator(name, factories, valuesSource, estimatedBucketCount, bucketCountThresholds, includeExclude, aggregationContext, parent, termsAggregatorFactory);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return false;
            }
        }
        ,
        GLOBAL_ORDINALS(new ParseField("global_ordinals", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggregatorFactory) {
                ValuesSource.Bytes.WithOrdinals valueSourceWithOrdinals = (ValuesSource.Bytes.WithOrdinals)valuesSource;
                ContextIndexSearcher indexSearcher = aggregationContext.searchContext().searcher();
                long maxOrd = valueSourceWithOrdinals.globalMaxOrd(indexSearcher);
                return new GlobalOrdinalsSignificantTermsAggregator(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, estimatedBucketCount, maxOrd, bucketCountThresholds, includeExclude, aggregationContext, parent, termsAggregatorFactory);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        }
        ,
        GLOBAL_ORDINALS_HASH(new ParseField("global_ordinals_hash", new String[0])){

            @Override
            Aggregator create(String name, AggregatorFactories factories, ValuesSource valuesSource, long estimatedBucketCount, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude includeExclude, AggregationContext aggregationContext, Aggregator parent, SignificantTermsAggregatorFactory termsAggregatorFactory) {
                return new GlobalOrdinalsSignificantTermsAggregator.WithHash(name, factories, (ValuesSource.Bytes.WithOrdinals.FieldData)valuesSource, estimatedBucketCount, bucketCountThresholds, includeExclude, aggregationContext, parent, termsAggregatorFactory);
            }

            @Override
            boolean needsGlobalOrdinals() {
                return true;
            }
        };

        private final ParseField parseField;

        public static ExecutionMode fromString(String value) {
            for (ExecutionMode mode : ExecutionMode.values()) {
                if (!mode.parseField.match(value)) continue;
                return mode;
            }
            throw new ElasticsearchIllegalArgumentException("Unknown `execution_hint`: [" + value + "], expected any of " + ExecutionMode.values());
        }

        private ExecutionMode(ParseField parseField) {
            this.parseField = parseField;
        }

        abstract Aggregator create(String var1, AggregatorFactories var2, ValuesSource var3, long var4, TermsAggregator.BucketCountThresholds var6, IncludeExclude var7, AggregationContext var8, Aggregator var9, SignificantTermsAggregatorFactory var10);

        abstract boolean needsGlobalOrdinals();

        public String toString() {
            return this.parseField.getPreferredName();
        }
    }
}

