/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregator;
import org.elasticsearch.search.aggregations.bucket.geogrid.InternalGeoHashGrid;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class GeoHashGridParser
implements Aggregator.Parser {
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;

    @Override
    public String type() {
        return InternalGeoHashGrid.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.GeoPoint> vsParser = ValuesSourceParser.geoPoint(aggregationName, InternalGeoHashGrid.TYPE, context).build();
        int precision = 5;
        int requiredSize = 10000;
        int shardSize = -1;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser) || token != XContentParser.Token.VALUE_NUMBER) continue;
            if ("precision".equals(currentFieldName)) {
                precision = parser.intValue();
                continue;
            }
            if ("size".equals(currentFieldName)) {
                requiredSize = parser.intValue();
                continue;
            }
            if (!"shard_size".equals(currentFieldName) && !"shardSize".equals(currentFieldName)) continue;
            shardSize = parser.intValue();
        }
        if (shardSize == 0) {
            shardSize = Integer.MAX_VALUE;
        }
        if (requiredSize == 0) {
            requiredSize = Integer.MAX_VALUE;
        }
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize, context.numberOfShards());
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return new GeoGridFactory(aggregationName, vsParser.config(), precision, requiredSize, shardSize);
    }

    private static class GeoGridFactory
    extends ValuesSourceAggregatorFactory<ValuesSource.GeoPoint> {
        private int precision;
        private int requiredSize;
        private int shardSize;

        public GeoGridFactory(String name, ValuesSourceConfig<ValuesSource.GeoPoint> config, int precision, int requiredSize, int shardSize) {
            super(name, InternalGeoHashGrid.TYPE.name(), config);
            this.precision = precision;
            this.requiredSize = requiredSize;
            this.shardSize = shardSize;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            final InternalGeoHashGrid aggregation = new InternalGeoHashGrid(this.name, this.requiredSize, Collections.emptyList());
            return new NonCollectingAggregator(this.name, aggregationContext, parent){

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return aggregation;
                }
            };
        }

        @Override
        protected Aggregator create(ValuesSource.GeoPoint valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            CellValues cellIdValues = new CellValues(valuesSource, this.precision);
            CellIdSource cellIdSource = new CellIdSource(cellIdValues, valuesSource.metaData());
            return new GeoHashGridAggregator(this.name, this.factories, cellIdSource, this.requiredSize, this.shardSize, aggregationContext, parent);
        }

        private static class CellIdSource
        extends ValuesSource.Numeric {
            private final SortedNumericDocValues values;
            private ValuesSource.MetaData metaData;

            public CellIdSource(SortedNumericDocValues values, ValuesSource.MetaData delegate) {
                this.values = values;
                this.metaData = ValuesSource.MetaData.builder(delegate).uniqueness(ValuesSource.MetaData.Uniqueness.UNKNOWN).build();
            }

            @Override
            public boolean isFloatingPoint() {
                return false;
            }

            @Override
            public SortedNumericDocValues longValues() {
                return this.values;
            }

            @Override
            public SortedNumericDoubleValues doubleValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public SortedBinaryDocValues bytesValues() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ValuesSource.MetaData metaData() {
                return this.metaData;
            }
        }

        private static class CellValues
        extends SortingNumericDocValues {
            private ValuesSource.GeoPoint geoPointValues;
            private MultiGeoPointValues geoValues;
            private int precision;

            protected CellValues(ValuesSource.GeoPoint geoPointValues, int precision) {
                this.geoPointValues = geoPointValues;
                this.precision = precision;
            }

            @Override
            public void setDocument(int docId) {
                this.geoValues = this.geoPointValues.geoPointValues();
                this.geoValues.setDocument(docId);
                this.resize(this.geoValues.count());
                for (int i = 0; i < this.count(); ++i) {
                    GeoPoint target = this.geoValues.valueAt(i);
                    this.values[i] = GeoHashUtils.encodeAsLong(target.getLat(), target.getLon(), this.precision);
                }
                this.sort();
            }
        }
    }
}

