/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.internal.ParentFieldMapper;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.children.InternalChildren;
import org.elasticsearch.search.aggregations.bucket.children.ParentToChildrenAggregator;
import org.elasticsearch.search.aggregations.support.FieldContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public class ChildrenParser
implements Aggregator.Parser {
    @Override
    public String type() {
        return InternalChildren.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        String childType = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("type".equals(currentFieldName)) {
                    childType = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (childType == null) {
            throw new SearchParseException(context, "Missing [child_type] field for children aggregation [" + aggregationName + "]");
        }
        ValuesSourceConfig<ValuesSource.Bytes.ParentChild> config = new ValuesSourceConfig<ValuesSource.Bytes.ParentChild>(ValuesSource.Bytes.ParentChild.class);
        DocumentMapper childDocMapper = context.mapperService().documentMapper(childType);
        String parentType = null;
        Filter parentFilter = null;
        Filter childFilter = null;
        if (childDocMapper != null) {
            ParentFieldMapper parentFieldMapper = childDocMapper.parentFieldMapper();
            if (!parentFieldMapper.active()) {
                throw new SearchParseException(context, "[children] _parent field not configured");
            }
            parentType = parentFieldMapper.type();
            DocumentMapper parentDocMapper = context.mapperService().documentMapper(parentType);
            if (parentDocMapper != null) {
                parentFilter = context.filterCache().cache(parentDocMapper.typeFilter());
                childFilter = context.filterCache().cache(childDocMapper.typeFilter());
                ParentChildIndexFieldData parentChildIndexFieldData = (ParentChildIndexFieldData)context.fieldData().getForField(parentFieldMapper);
                config.fieldContext(new FieldContext(parentFieldMapper.names().indexName(), parentChildIndexFieldData, parentFieldMapper));
            } else {
                config.unmapped(true);
            }
        } else {
            config.unmapped(true);
        }
        return new ParentToChildrenAggregator.Factory(aggregationName, config, parentType, parentFilter, childFilter);
    }
}

