/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.FilteringBucketCollector;
import org.elasticsearch.search.aggregations.RecordingBucketCollector;
import org.elasticsearch.search.aggregations.RecordingPerReaderBucketCollector;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.query.QueryPhaseExecutionException;

public class DeferringBucketCollector
extends BucketCollector
implements Releasable {
    private final BucketCollector deferred;
    private final RecordingBucketCollector recording;
    private final AggregationContext context;
    private FilteringBucketCollector filteredCollector;

    public DeferringBucketCollector(BucketCollector deferred, AggregationContext context) {
        this.deferred = deferred;
        this.recording = new RecordingPerReaderBucketCollector(context);
        this.context = context;
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.recording.setNextReader(reader);
    }

    @Override
    public void collect(int docId, long bucketOrdinal) throws IOException {
        this.recording.collect(docId, bucketOrdinal);
    }

    @Override
    public void postCollection() throws IOException {
        this.recording.postCollection();
    }

    public void prepareSelectedBuckets(long ... survivingBucketOrds) {
        BucketCollector subs = new BucketCollector(){

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                DeferringBucketCollector.this.context.setNextReader(reader);
                DeferringBucketCollector.this.deferred.setNextReader(reader);
            }

            @Override
            public void collect(int docId, long bucketOrdinal) throws IOException {
                DeferringBucketCollector.this.deferred.collect(docId, bucketOrdinal);
            }

            @Override
            public void postCollection() throws IOException {
                DeferringBucketCollector.this.deferred.postCollection();
            }

            @Override
            public void gatherAnalysis(BucketCollector.BucketAnalysisCollector results, long bucketOrdinal) {
                DeferringBucketCollector.this.deferred.gatherAnalysis(results, bucketOrdinal);
            }
        };
        this.filteredCollector = new FilteringBucketCollector(survivingBucketOrds, subs, this.context.bigArrays());
        try {
            this.recording.replayCollection(this.filteredCollector);
        }
        catch (IOException e) {
            throw new QueryPhaseExecutionException(this.context.searchContext(), "Failed to replay deferred set of matching docIDs", (Throwable)e);
        }
    }

    @Override
    public void close() throws ElasticsearchException {
        Releasables.close(this.recording, this.filteredCollector);
    }

    @Override
    public void gatherAnalysis(BucketCollector.BucketAnalysisCollector analysisCollector, long bucketOrdinal) {
        this.filteredCollector.gatherAnalysis(analysisCollector, bucketOrdinal);
    }
}

