/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.BucketCollector;

public class FilteringBucketCollector
extends BucketCollector
implements Releasable {
    private final LongHash denseMap;
    private final BucketCollector delegate;

    public FilteringBucketCollector(long[] validBucketOrds, BucketCollector delegate, BigArrays bigArrays) {
        this.denseMap = new LongHash(validBucketOrds.length, bigArrays);
        for (int i = 0; i < validBucketOrds.length; ++i) {
            this.denseMap.add(validBucketOrds[i]);
        }
        this.delegate = delegate;
    }

    @Override
    public final void setNextReader(AtomicReaderContext reader) {
        this.delegate.setNextReader(reader);
    }

    @Override
    public final void collect(int docId, long bucketOrdinal) throws IOException {
        long ordinal = this.denseMap.find(bucketOrdinal);
        if (ordinal >= 0L) {
            this.delegate.collect(docId, ordinal);
        }
    }

    @Override
    public final void postCollection() throws IOException {
        this.delegate.postCollection();
    }

    @Override
    public void close() throws ElasticsearchException {
        Releasables.close(this.denseMap);
    }

    @Override
    public void gatherAnalysis(BucketCollector.BucketAnalysisCollector analysisCollector, long bucketOrdinal) {
        long ordinal = this.denseMap.find(bucketOrdinal);
        if (ordinal < 0L) {
            throw new ElasticsearchIllegalArgumentException("Aggregation requested on a missing bucket #" + bucketOrdinal);
        }
        this.delegate.gatherAnalysis(analysisCollector, ordinal);
    }
}

