/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.elasticsearch.common.collect.Iterables;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.search.aggregations.Aggregation;

public abstract class BucketCollector
implements ReaderContextAware {
    public static final BucketCollector NO_OP_COLLECTOR = new BucketCollector(){

        @Override
        public void collect(int docId, long bucketOrdinal) throws IOException {
        }

        @Override
        public void setNextReader(AtomicReaderContext reader) {
        }

        @Override
        public void postCollection() throws IOException {
        }

        @Override
        public void gatherAnalysis(BucketAnalysisCollector analysisCollector, long bucketOrdinal) {
        }
    };

    public static BucketCollector wrap(Iterable<? extends BucketCollector> collectorList) {
        final BucketCollector[] collectors = Iterables.toArray(collectorList, BucketCollector.class);
        switch (collectors.length) {
            case 0: {
                return NO_OP_COLLECTOR;
            }
            case 1: {
                return collectors[0];
            }
        }
        return new BucketCollector(){

            @Override
            public void collect(int docId, long bucketOrdinal) throws IOException {
                for (BucketCollector collector : collectors) {
                    collector.collect(docId, bucketOrdinal);
                }
            }

            @Override
            public void setNextReader(AtomicReaderContext reader) {
                for (BucketCollector collector : collectors) {
                    collector.setNextReader(reader);
                }
            }

            @Override
            public void postCollection() throws IOException {
                for (BucketCollector collector : collectors) {
                    collector.postCollection();
                }
            }

            @Override
            public void gatherAnalysis(BucketAnalysisCollector results, long bucketOrdinal) {
                for (BucketCollector collector : collectors) {
                    collector.gatherAnalysis(results, bucketOrdinal);
                }
            }
        };
    }

    public abstract void collect(int var1, long var2) throws IOException;

    public abstract void postCollection() throws IOException;

    public abstract void gatherAnalysis(BucketAnalysisCollector var1, long var2);

    public static interface BucketAnalysisCollector {
        public void add(Aggregation var1);
    }
}

