/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search;

import java.util.Locale;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.NumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.RandomAccessOrds;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;

public enum MultiValueMode {
    SUM{

        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public long apply(long a, long b) {
            return a + b;
        }
    }
    ,
    AVG{

        @Override
        public double apply(double a, double b) {
            return a + b;
        }

        @Override
        public long apply(long a, long b) {
            return a + b;
        }

        @Override
        public double reduce(double a, int numValues) {
            return a / Math.max(1.0, (double)numValues);
        }

        @Override
        public long reduce(long a, int numValues) {
            if (numValues <= 1) {
                return a;
            }
            return Math.round((double)a / Math.max(1.0, (double)numValues));
        }
    }
    ,
    MIN{

        @Override
        public double apply(double a, double b) {
            return Math.min(a, b);
        }

        @Override
        public long apply(long a, long b) {
            return Math.min(a, b);
        }

        @Override
        public int applyOrd(int ord1, int ord2) {
            return Math.min(ord1, ord2);
        }

        @Override
        public BytesRef apply(BytesRef a, BytesRef b) {
            return a.compareTo(b) <= 0 ? a : b;
        }

        @Override
        public double startDouble() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public long startLong() {
            return Long.MAX_VALUE;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue) {
            if (values.count() > 0) {
                return values.valueAt(0);
            }
            return missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue) {
            if (values.count() > 0) {
                return values.valueAt(0);
            }
            return missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue) {
            if (values.count() > 0) {
                return values.valueAt(0);
            }
            return missingValue;
        }

        @Override
        protected int pick(RandomAccessOrds values) {
            if (values.cardinality() > 0) {
                return (int)values.ordAt(0);
            }
            return -1;
        }
    }
    ,
    MAX{

        @Override
        public double apply(double a, double b) {
            return Math.max(a, b);
        }

        @Override
        public long apply(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        public int applyOrd(int ord1, int ord2) {
            return Math.max(ord1, ord2);
        }

        @Override
        public BytesRef apply(BytesRef a, BytesRef b) {
            return a.compareTo(b) > 0 ? a : b;
        }

        @Override
        public double startDouble() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public long startLong() {
            return Long.MIN_VALUE;
        }

        @Override
        protected long pick(SortedNumericDocValues values, long missingValue) {
            int count = values.count();
            if (count > 0) {
                return values.valueAt(count - 1);
            }
            return missingValue;
        }

        @Override
        protected double pick(SortedNumericDoubleValues values, double missingValue) {
            int count = values.count();
            if (count > 0) {
                return values.valueAt(count - 1);
            }
            return missingValue;
        }

        @Override
        protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue) {
            int count = values.count();
            if (count > 0) {
                return values.valueAt(count - 1);
            }
            return missingValue;
        }

        @Override
        protected int pick(RandomAccessOrds values) {
            int count = values.cardinality();
            if (count > 0) {
                return (int)values.ordAt(count - 1);
            }
            return -1;
        }
    };


    public abstract double apply(double var1, double var3);

    public abstract long apply(long var1, long var3);

    public int applyOrd(int ord1, int ord2) {
        throw new UnsupportedOperationException();
    }

    public BytesRef apply(BytesRef a, BytesRef b) {
        throw new UnsupportedOperationException();
    }

    public double startDouble() {
        return 0.0;
    }

    public long startLong() {
        return 0L;
    }

    public double reduce(double a, int numValues) {
        return a;
    }

    public long reduce(long a, int numValues) {
        return a;
    }

    public static MultiValueMode fromString(String sortMode) {
        try {
            return MultiValueMode.valueOf(sortMode.toUpperCase(Locale.ROOT));
        }
        catch (Throwable t) {
            throw new ElasticsearchIllegalArgumentException("Illegal sort_mode " + sortMode);
        }
    }

    protected long pick(SortedNumericDocValues values, long missingValue) {
        int count = values.count();
        if (count == 0) {
            return missingValue;
        }
        long aggregate = this.startLong();
        for (int i = 0; i < count; ++i) {
            aggregate = this.apply(aggregate, values.valueAt(i));
        }
        return this.reduce(aggregate, count);
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue) {
        final NumericDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            final Bits docsWithField = DocValues.unwrapSingletonBits(values);
            if (docsWithField == null || missingValue == 0L) {
                return singleton;
            }
            return new NumericDocValues(){

                @Override
                public long get(int docID) {
                    long value = singleton.get(docID);
                    if (value == 0L && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new NumericDocValues(){

            @Override
            public long get(int docID) {
                values.setDocument(docID);
                return MultiValueMode.this.pick(values, missingValue);
            }
        };
    }

    public NumericDocValues select(final SortedNumericDocValues values, final long missingValue, final FixedBitSet rootDocs, final FixedBitSet innerDocs, int maxDoc) {
        if (rootDocs == null || innerDocs == null) {
            return this.select(DocValues.emptySortedNumeric(maxDoc), missingValue);
        }
        return new NumericDocValues(){

            @Override
            public long get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                if (rootDoc == 0) {
                    return missingValue;
                }
                int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                int firstNestedDoc = innerDocs.nextSetBit(prevRootDoc + 1);
                long accumulated = MultiValueMode.this.startLong();
                int numValues = 0;
                int doc = firstNestedDoc;
                while (doc != -1 && doc < rootDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int i = 0; i < count; ++i) {
                        long value = values.valueAt(i);
                        accumulated = MultiValueMode.this.apply(accumulated, value);
                    }
                    numValues += count;
                    doc = innerDocs.nextSetBit(doc + 1);
                }
                return numValues == 0 ? missingValue : MultiValueMode.this.reduce(accumulated, numValues);
            }
        };
    }

    protected double pick(SortedNumericDoubleValues values, double missingValue) {
        int count = values.count();
        if (count == 0) {
            return missingValue;
        }
        double aggregate = this.startDouble();
        for (int i = 0; i < count; ++i) {
            aggregate = this.apply(aggregate, values.valueAt(i));
        }
        return this.reduce(aggregate, count);
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue) {
        final NumericDoubleValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            final Bits docsWithField = FieldData.unwrapSingletonBits(values);
            if (docsWithField == null || missingValue == 0.0) {
                return singleton;
            }
            return new NumericDoubleValues(){

                @Override
                public double get(int docID) {
                    double value = singleton.get(docID);
                    if (value == 0.0 && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new NumericDoubleValues(){

            @Override
            public double get(int docID) {
                values.setDocument(docID);
                return MultiValueMode.this.pick(values, missingValue);
            }
        };
    }

    public NumericDoubleValues select(final SortedNumericDoubleValues values, final double missingValue, final FixedBitSet rootDocs, final FixedBitSet innerDocs, int maxDoc) {
        if (rootDocs == null || innerDocs == null) {
            return this.select(FieldData.emptySortedNumericDoubles(maxDoc), missingValue);
        }
        return new NumericDoubleValues(){

            @Override
            public double get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                if (rootDoc == 0) {
                    return missingValue;
                }
                int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                int firstNestedDoc = innerDocs.nextSetBit(prevRootDoc + 1);
                double accumulated = MultiValueMode.this.startDouble();
                int numValues = 0;
                int doc = firstNestedDoc;
                while (doc != -1 && doc < rootDoc) {
                    values.setDocument(doc);
                    int count = values.count();
                    for (int i = 0; i < count; ++i) {
                        double value = values.valueAt(i);
                        accumulated = MultiValueMode.this.apply(accumulated, value);
                    }
                    numValues += count;
                    doc = innerDocs.nextSetBit(doc + 1);
                }
                return numValues == 0 ? missingValue : MultiValueMode.this.reduce(accumulated, numValues);
            }
        };
    }

    protected BytesRef pick(SortedBinaryDocValues values, BytesRef missingValue) {
        throw new ElasticsearchIllegalArgumentException("Unsupported sort mode: " + (Object)((Object)this));
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue) {
        final BinaryDocValues singleton = FieldData.unwrapSingleton(values);
        if (singleton != null) {
            final Bits docsWithField = FieldData.unwrapSingletonBits(values);
            if (docsWithField == null) {
                return singleton;
            }
            return new BinaryDocValues(){

                @Override
                public BytesRef get(int docID) {
                    BytesRef value = singleton.get(docID);
                    if (value.length == 0 && !docsWithField.get(docID)) {
                        return missingValue;
                    }
                    return value;
                }
            };
        }
        return new BinaryDocValues(){

            @Override
            public BytesRef get(int docID) {
                values.setDocument(docID);
                return MultiValueMode.this.pick(values, missingValue);
            }
        };
    }

    public BinaryDocValues select(final SortedBinaryDocValues values, final BytesRef missingValue, final FixedBitSet rootDocs, final FixedBitSet innerDocs, int maxDoc) {
        if (rootDocs == null || innerDocs == null) {
            return this.select(FieldData.emptySortedBinary(maxDoc), missingValue);
        }
        final BinaryDocValues selectedValues = this.select(values, new BytesRef());
        final Bits docsWithValue = FieldData.unwrapSingleton(values) != null ? FieldData.unwrapSingletonBits(values) : FieldData.docsWithValue(values, maxDoc);
        return new BinaryDocValues(){
            final BytesRefBuilder spare = new BytesRefBuilder();

            @Override
            public BytesRef get(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                if (rootDoc == 0) {
                    return missingValue;
                }
                int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                int firstNestedDoc = innerDocs.nextSetBit(prevRootDoc + 1);
                BytesRefBuilder accumulated = null;
                int doc = firstNestedDoc;
                while (doc != -1 && doc < rootDoc) {
                    values.setDocument(doc);
                    BytesRef innerValue = selectedValues.get(doc);
                    if (innerValue.length > 0 || docsWithValue == null || docsWithValue.get(doc)) {
                        if (accumulated == null) {
                            this.spare.copyBytes(innerValue);
                            accumulated = this.spare;
                        } else {
                            BytesRef applied = MultiValueMode.this.apply(accumulated.get(), innerValue);
                            if (applied == innerValue) {
                                accumulated.copyBytes(innerValue);
                            }
                        }
                    }
                    doc = innerDocs.nextSetBit(doc + 1);
                }
                return accumulated == null ? missingValue : accumulated.get();
            }
        };
    }

    protected int pick(RandomAccessOrds values) {
        throw new ElasticsearchIllegalArgumentException("Unsupported sort mode: " + (Object)((Object)this));
    }

    public SortedDocValues select(final RandomAccessOrds values) {
        if (values.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton(values);
        if (singleton != null) {
            return singleton;
        }
        return new SortedDocValues(){

            @Override
            public int getOrd(int docID) {
                values.setDocument(docID);
                return MultiValueMode.this.pick(values);
            }

            @Override
            public BytesRef lookupOrd(int ord) {
                return values.lookupOrd(ord);
            }

            @Override
            public int getValueCount() {
                return (int)values.getValueCount();
            }
        };
    }

    public SortedDocValues select(RandomAccessOrds values, final FixedBitSet rootDocs, final FixedBitSet innerDocs) {
        if (rootDocs == null || innerDocs == null) {
            return this.select(DocValues.emptySortedSet());
        }
        final SortedDocValues selectedValues = this.select(values);
        return new SortedDocValues(){

            @Override
            public BytesRef lookupOrd(int ord) {
                return selectedValues.lookupOrd(ord);
            }

            @Override
            public int getValueCount() {
                return selectedValues.getValueCount();
            }

            @Override
            public int getOrd(int rootDoc) {
                assert (rootDocs.get(rootDoc)) : "can only sort root documents";
                if (rootDoc == 0) {
                    return -1;
                }
                int prevRootDoc = rootDocs.prevSetBit(rootDoc - 1);
                int firstNestedDoc = innerDocs.nextSetBit(prevRootDoc + 1);
                int ord = -1;
                int doc = firstNestedDoc;
                while (doc != -1 && doc < rootDoc) {
                    int innerOrd = selectedValues.getOrd(doc);
                    if (innerOrd != -1) {
                        ord = ord == -1 ? innerOrd : MultiValueMode.this.applyOrd(ord, innerOrd);
                    }
                    doc = innerDocs.nextSetBit(doc + 1);
                }
                return ord;
            }
        };
    }
}

