/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.template.get;

import java.util.HashMap;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestGetIndexTemplateAction
extends BaseRestHandler {
    @Inject
    public RestGetIndexTemplateAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_template", this);
        controller.registerHandler(RestRequest.Method.GET, "/_template/{name}", this);
    }

    @Override
    public void handleRequest(final RestRequest request, RestChannel channel, Client client) {
        String[] names = Strings.splitStringByCommaToArray(request.param("name"));
        GetIndexTemplatesRequest getIndexTemplatesRequest = new GetIndexTemplatesRequest(names);
        getIndexTemplatesRequest.local(request.paramAsBoolean("local", getIndexTemplatesRequest.local()));
        getIndexTemplatesRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexTemplatesRequest.masterNodeTimeout()));
        getIndexTemplatesRequest.listenerThreaded(false);
        final boolean implicitAll = getIndexTemplatesRequest.names().length == 0;
        client.admin().indices().getTemplates(getIndexTemplatesRequest, (ActionListener<GetIndexTemplatesResponse>)new RestBuilderListener<GetIndexTemplatesResponse>(channel){

            @Override
            public RestResponse buildResponse(GetIndexTemplatesResponse getIndexTemplatesResponse, XContentBuilder builder) throws Exception {
                boolean templateExists = getIndexTemplatesResponse.getIndexTemplates().size() > 0;
                HashMap<String, String> paramsMap = Maps.newHashMap();
                paramsMap.put("reduce_mappings", "true");
                ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(paramsMap, request);
                builder.startObject();
                for (IndexTemplateMetaData indexTemplateMetaData : getIndexTemplatesResponse.getIndexTemplates()) {
                    IndexTemplateMetaData.Builder.toXContent(indexTemplateMetaData, builder, params);
                }
                builder.endObject();
                RestStatus restStatus = templateExists || implicitAll ? RestStatus.OK : RestStatus.NOT_FOUND;
                return new BytesRestResponse(restStatus, builder);
            }
        });
    }
}

