/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.CancellableThreads;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.RecoveryFailedException;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.RecoveryTarget;

public class RecoveryStatus
extends AbstractRefCounted {
    private final ESLogger logger;
    private static final AtomicLong idGenerator = new AtomicLong();
    private final String RECOVERY_PREFIX = "recovery.";
    private final ShardId shardId;
    private final long recoveryId;
    private final IndexShard indexShard;
    private final DiscoveryNode sourceNode;
    private final String tempFilePrefix;
    private final Store store;
    private final RecoveryTarget.RecoveryListener listener;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    private final Store.LegacyChecksums legacyChecksums = new Store.LegacyChecksums();
    private final CancellableThreads cancellableThreads = new CancellableThreads();
    private volatile long lastAccessTime = System.nanoTime();
    private final Map<String, String> tempFileNames = ConcurrentCollections.newConcurrentMap();

    public RecoveryStatus(IndexShard indexShard, DiscoveryNode sourceNode, RecoveryTarget.RecoveryListener listener) {
        super("recovery_status");
        this.recoveryId = idGenerator.incrementAndGet();
        this.listener = listener;
        this.logger = Loggers.getLogger(this.getClass(), indexShard.indexSettings(), indexShard.shardId(), new String[0]);
        this.indexShard = indexShard;
        this.sourceNode = sourceNode;
        this.shardId = indexShard.shardId();
        this.tempFilePrefix = "recovery." + indexShard.recoveryState().getTimer().startTime() + ".";
        this.store = indexShard.store();
        this.store.incRef();
        indexShard.recoveryStats().incCurrentAsTarget();
    }

    public long recoveryId() {
        return this.recoveryId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexShard indexShard() {
        this.ensureRefCount();
        return this.indexShard;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public RecoveryState state() {
        return this.indexShard.recoveryState();
    }

    public CancellableThreads CancellableThreads() {
        return this.cancellableThreads;
    }

    public long lastAccessTime() {
        return this.lastAccessTime;
    }

    public void setLastAccessTime() {
        this.lastAccessTime = System.nanoTime();
    }

    public Store store() {
        this.ensureRefCount();
        return this.store;
    }

    public RecoveryState.Stage stage() {
        return this.state().getStage();
    }

    public Store.LegacyChecksums legacyChecksums() {
        return this.legacyChecksums;
    }

    public void renameAllTempFiles() throws IOException {
        this.ensureRefCount();
        this.store.renameTempFilesSafe(this.tempFileNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(String reason) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.logger.debug("recovery canceled (reason: [{}])", reason);
                this.cancellableThreads.cancel(reason);
            }
            finally {
                this.decRef();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(RecoveryFailedException e, boolean sendShardFailure) {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.listener.onRecoveryFailure(this.state(), e, sendShardFailure);
            }
            finally {
                try {
                    this.cancellableThreads.cancel("failed recovery [" + e.getMessage() + "]");
                }
                finally {
                    this.decRef();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsDone() {
        if (this.finished.compareAndSet(false, true)) {
            assert (this.tempFileNames.isEmpty()) : "not all temporary files are renamed";
            try {
                this.indexShard.postRecovery("peer recovery done");
            }
            finally {
                this.decRef();
            }
            this.listener.onRecoveryDone(this.state());
        }
    }

    public String getTempNameForFile(String origFile) {
        return this.tempFilePrefix + origFile;
    }

    public IndexOutput getOpenIndexOutput(String key) {
        this.ensureRefCount();
        return (IndexOutput)this.openIndexOutputs.get(key);
    }

    public IndexOutput removeOpenIndexOutputs(String name) {
        this.ensureRefCount();
        return (IndexOutput)this.openIndexOutputs.remove(name);
    }

    public IndexOutput openAndPutIndexOutput(String fileName, StoreFileMetaData metaData, Store store) throws IOException {
        this.ensureRefCount();
        String tempFileName = this.getTempNameForFile(fileName);
        this.tempFileNames.put(tempFileName, fileName);
        IndexOutput indexOutput = store.createVerifyingOutput(tempFileName, metaData, IOContext.DEFAULT);
        this.openIndexOutputs.put(fileName, indexOutput);
        return indexOutput;
    }

    public void resetRecovery() throws IOException {
        this.cleanOpenFiles();
        this.indexShard().performRecoveryRestart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeInternal() {
        try {
            this.cleanOpenFiles();
        }
        finally {
            this.store.decRef();
            this.indexShard.recoveryStats().decCurrentAsTarget();
        }
    }

    protected void cleanOpenFiles() {
        Iterator iterator = this.openIndexOutputs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.logger.trace("closing IndexOutput file [{}]", entry.getValue());
            try {
                ((IndexOutput)entry.getValue()).close();
            }
            catch (Throwable t) {
                this.logger.debug("error while closing recovery output [{}]", t, entry.getValue());
            }
            iterator.remove();
        }
        for (String file : this.tempFileNames.keySet()) {
            this.logger.trace("cleaning temporary file [{}]", file);
            this.store.deleteQuiet(file);
        }
        this.legacyChecksums.clear();
    }

    public String toString() {
        return this.shardId + " [" + this.recoveryId + "]";
    }

    private void ensureRefCount() {
        if (this.refCount() <= 0) {
            throw new ElasticsearchException("RecoveryStatus is used but it's refcount is 0. Probably a mismatch between incRef/decRef calls");
        }
    }
}

