/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.SharedFSRecoverySourceHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportService;

public class RecoverySource
extends AbstractComponent {
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final RecoverySettings recoverySettings;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final ClusterService clusterService;
    private final OngoingRecoveres ongoingRecoveries = new OngoingRecoveres();

    @Inject
    public RecoverySource(Settings settings, TransportService transportService, IndicesService indicesService, RecoverySettings recoverySettings, MappingUpdatedAction mappingUpdatedAction, ClusterService clusterService) {
        super(settings);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.clusterService = clusterService;
        this.indicesService.indicesLifecycle().addListener(new IndicesLifecycle.Listener(){

            @Override
            public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, @IndexSettings Settings indexSettings) {
                if (indexShard != null) {
                    RecoverySource.this.ongoingRecoveries.cancel(indexShard, "shard is closed");
                }
            }
        });
        this.recoverySettings = recoverySettings;
        transportService.registerHandler("internal:index/shard/recovery/start_recovery", new StartRecoveryTransportRequestHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecoveryResponse recover(StartRecoveryRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().index().name());
        IndexShard shard = indexService.shardSafe(request.shardId().id());
        RoutingNode node = this.clusterService.state().readOnlyRoutingNodes().node(request.targetNode().id());
        if (node == null) {
            this.logger.debug("delaying recovery of {} as source node {} is unknown", request.shardId(), request.targetNode());
            throw new DelayRecoveryException("source node does not have the node [" + request.targetNode() + "] in its state yet..");
        }
        ShardRouting targetShardRouting = null;
        for (ShardRouting shardRouting : node) {
            if (!shardRouting.shardId().equals(request.shardId())) continue;
            targetShardRouting = shardRouting;
            break;
        }
        if (targetShardRouting == null) {
            this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", request.shardId(), request.targetNode());
            throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
        }
        if (!targetShardRouting.initializing()) {
            this.logger.debug("delaying recovery of {} as it is not listed as initializing on the target node {}. known shards state is [{}]", new Object[]{request.shardId(), request.targetNode(), targetShardRouting.state()});
            throw new DelayRecoveryException("source node has the state of the target shard to be [" + (Object)((Object)targetShardRouting.state()) + "], expecting to be [initializing]");
        }
        this.logger.trace("[{}][{}] starting recovery to {}, mark_as_relocated {}", request.shardId().index().name(), request.shardId().id(), request.targetNode(), request.markAsRelocated());
        RecoverySourceHandler handler = IndexMetaData.isOnSharedFilesystem(shard.indexSettings()) ? new SharedFSRecoverySourceHandler(shard, request, this.recoverySettings, this.transportService, this.clusterService, this.indicesService, this.mappingUpdatedAction, this.logger) : new RecoverySourceHandler(shard, request, this.recoverySettings, this.transportService, this.clusterService, this.indicesService, this.mappingUpdatedAction, this.logger);
        this.ongoingRecoveries.add(shard, handler);
        try {
            shard.recover(handler);
        }
        finally {
            this.ongoingRecoveries.remove(shard, handler);
        }
        return handler.getResponse();
    }

    private static final class OngoingRecoveres {
        private final Map<IndexShard, Set<RecoverySourceHandler>> ongoingRecoveries = new HashMap<IndexShard, Set<RecoverySourceHandler>>();

        private OngoingRecoveres() {
        }

        synchronized void add(IndexShard shard, RecoverySourceHandler handler) {
            Set<RecoverySourceHandler> shardRecoveryHandlers = this.ongoingRecoveries.get(shard);
            if (shardRecoveryHandlers == null) {
                shardRecoveryHandlers = new HashSet<RecoverySourceHandler>();
                this.ongoingRecoveries.put(shard, shardRecoveryHandlers);
            }
            assert (!shardRecoveryHandlers.contains(handler)) : "Handler was already registered [" + handler + "]";
            shardRecoveryHandlers.add(handler);
            shard.recoveryStats().incCurrentAsSource();
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            Set<RecoverySourceHandler> shardRecoveryHandlers = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryHandlers != null) : "Shard was not registered [" + shard + "]";
            boolean remove = shardRecoveryHandlers.remove(handler);
            assert (remove) : "Handler was not registered [" + handler + "]";
            if (remove) {
                shard.recoveryStats().decCurrentAsSource();
            }
            if (shardRecoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            Set<RecoverySourceHandler> shardRecoveryHandlers = this.ongoingRecoveries.get(shard);
            if (shardRecoveryHandlers != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryHandlers) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                ExceptionsHelper.maybeThrowRuntimeAndSuppress(failures);
            }
        }
    }

    class StartRecoveryTransportRequestHandler
    extends BaseTransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public StartRecoveryRequest newInstance() {
            return new StartRecoveryRequest();
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            RecoveryResponse response = RecoverySource.this.recover(request);
            channel.sendResponse(response);
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
    }
}

