/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.analysis;

import java.util.Locale;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.cn.ChineseAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.miscellaneous.PatternAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.snowball.SnowballAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tr.TurkishAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.elasticsearch.Version;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzer;
import org.elasticsearch.indices.analysis.PreBuiltCacheFactory;

public enum PreBuiltAnalyzers {
    STANDARD(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            if (version.onOrAfter(Version.V_1_0_0_Beta1)) {
                return new StandardAnalyzer(version.luceneVersion, CharArraySet.EMPTY_SET);
            }
            return new StandardAnalyzer(version.luceneVersion);
        }
    }
    ,
    DEFAULT(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            return STANDARD.getAnalyzer(version);
        }
    }
    ,
    KEYWORD(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version) {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer create(Version version) {
            return new StopAnalyzer(version.luceneVersion);
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer create(Version version) {
            return new WhitespaceAnalyzer(version.luceneVersion);
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer create(Version version) {
            return new SimpleAnalyzer(version.luceneVersion);
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer create(Version version) {
            return new ClassicAnalyzer(version.luceneVersion);
        }
    }
    ,
    SNOWBALL{

        @Override
        protected Analyzer create(Version version) {
            return new SnowballAnalyzer(version.luceneVersion, "English", StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        }
    }
    ,
    PATTERN(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            if (version.onOrAfter(Version.V_1_0_0_RC1)) {
                return new PatternAnalyzer(version.luceneVersion, Regex.compile("\\W+", null), true, CharArraySet.EMPTY_SET);
            }
            return new PatternAnalyzer(version.luceneVersion, Regex.compile("\\W+", null), true, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        }
    }
    ,
    STANDARD_HTML_STRIP(PreBuiltCacheFactory.CachingStrategy.ELASTICSEARCH){

        @Override
        protected Analyzer create(Version version) {
            if (version.onOrAfter(Version.V_1_0_0_RC1)) {
                return new StandardHtmlStripAnalyzer(version.luceneVersion, CharArraySet.EMPTY_SET);
            }
            return new StandardHtmlStripAnalyzer(version.luceneVersion);
        }
    }
    ,
    ARABIC{

        @Override
        protected Analyzer create(Version version) {
            return new ArabicAnalyzer(version.luceneVersion);
        }
    }
    ,
    ARMENIAN{

        @Override
        protected Analyzer create(Version version) {
            return new ArmenianAnalyzer(version.luceneVersion);
        }
    }
    ,
    BASQUE{

        @Override
        protected Analyzer create(Version version) {
            return new BasqueAnalyzer(version.luceneVersion);
        }
    }
    ,
    BRAZILIAN{

        @Override
        protected Analyzer create(Version version) {
            return new BrazilianAnalyzer(version.luceneVersion);
        }
    }
    ,
    BULGARIAN{

        @Override
        protected Analyzer create(Version version) {
            return new BulgarianAnalyzer(version.luceneVersion);
        }
    }
    ,
    CATALAN{

        @Override
        protected Analyzer create(Version version) {
            return new CatalanAnalyzer(version.luceneVersion);
        }
    }
    ,
    CHINESE(PreBuiltCacheFactory.CachingStrategy.ONE){

        @Override
        protected Analyzer create(Version version) {
            return new ChineseAnalyzer();
        }
    }
    ,
    CJK{

        @Override
        protected Analyzer create(Version version) {
            return new CJKAnalyzer(version.luceneVersion);
        }
    }
    ,
    CZECH{

        @Override
        protected Analyzer create(Version version) {
            return new CzechAnalyzer(version.luceneVersion);
        }
    }
    ,
    DUTCH{

        @Override
        protected Analyzer create(Version version) {
            return new DutchAnalyzer(version.luceneVersion);
        }
    }
    ,
    DANISH{

        @Override
        protected Analyzer create(Version version) {
            return new DanishAnalyzer(version.luceneVersion);
        }
    }
    ,
    ENGLISH{

        @Override
        protected Analyzer create(Version version) {
            return new EnglishAnalyzer(version.luceneVersion);
        }
    }
    ,
    FINNISH{

        @Override
        protected Analyzer create(Version version) {
            return new FinnishAnalyzer(version.luceneVersion);
        }
    }
    ,
    FRENCH{

        @Override
        protected Analyzer create(Version version) {
            return new FrenchAnalyzer(version.luceneVersion);
        }
    }
    ,
    GALICIAN{

        @Override
        protected Analyzer create(Version version) {
            return new GalicianAnalyzer(version.luceneVersion);
        }
    }
    ,
    GERMAN{

        @Override
        protected Analyzer create(Version version) {
            return new GermanAnalyzer(version.luceneVersion);
        }
    }
    ,
    GREEK{

        @Override
        protected Analyzer create(Version version) {
            return new GreekAnalyzer(version.luceneVersion);
        }
    }
    ,
    HINDI{

        @Override
        protected Analyzer create(Version version) {
            return new HindiAnalyzer(version.luceneVersion);
        }
    }
    ,
    HUNGARIAN{

        @Override
        protected Analyzer create(Version version) {
            return new HungarianAnalyzer(version.luceneVersion);
        }
    }
    ,
    INDONESIAN{

        @Override
        protected Analyzer create(Version version) {
            return new IndonesianAnalyzer(version.luceneVersion);
        }
    }
    ,
    IRISH{

        @Override
        protected Analyzer create(Version version) {
            return new IrishAnalyzer(version.luceneVersion);
        }
    }
    ,
    ITALIAN{

        @Override
        protected Analyzer create(Version version) {
            return new ItalianAnalyzer(version.luceneVersion);
        }
    }
    ,
    LATVIAN{

        @Override
        protected Analyzer create(Version version) {
            return new LatvianAnalyzer(version.luceneVersion);
        }
    }
    ,
    NORWEGIAN{

        @Override
        protected Analyzer create(Version version) {
            return new NorwegianAnalyzer(version.luceneVersion);
        }
    }
    ,
    PERSIAN{

        @Override
        protected Analyzer create(Version version) {
            return new PersianAnalyzer(version.luceneVersion);
        }
    }
    ,
    PORTUGUESE{

        @Override
        protected Analyzer create(Version version) {
            return new PortugueseAnalyzer(version.luceneVersion);
        }
    }
    ,
    ROMANIAN{

        @Override
        protected Analyzer create(Version version) {
            return new RomanianAnalyzer(version.luceneVersion);
        }
    }
    ,
    RUSSIAN{

        @Override
        protected Analyzer create(Version version) {
            return new RussianAnalyzer(version.luceneVersion);
        }
    }
    ,
    SORANI{

        @Override
        protected Analyzer create(Version version) {
            return new SoraniAnalyzer(version.luceneVersion);
        }
    }
    ,
    SPANISH{

        @Override
        protected Analyzer create(Version version) {
            return new SpanishAnalyzer(version.luceneVersion);
        }
    }
    ,
    SWEDISH{

        @Override
        protected Analyzer create(Version version) {
            return new SwedishAnalyzer(version.luceneVersion);
        }
    }
    ,
    TURKISH{

        @Override
        protected Analyzer create(Version version) {
            return new TurkishAnalyzer(version.luceneVersion);
        }
    }
    ,
    THAI{

        @Override
        protected Analyzer create(Version version) {
            return new ThaiAnalyzer(version.luceneVersion);
        }
    };

    protected final PreBuiltCacheFactory.PreBuiltCache<Analyzer> cache;

    protected abstract Analyzer create(Version var1);

    private PreBuiltAnalyzers() {
        this(PreBuiltCacheFactory.CachingStrategy.LUCENE);
    }

    private PreBuiltAnalyzers(PreBuiltCacheFactory.CachingStrategy cachingStrategy) {
        this.cache = PreBuiltCacheFactory.getCache(cachingStrategy);
    }

    PreBuiltCacheFactory.PreBuiltCache<Analyzer> getCache() {
        return this.cache;
    }

    public synchronized Analyzer getAnalyzer(Version version) {
        Analyzer analyzer = this.cache.get(version);
        if (analyzer == null) {
            analyzer = this.create(version);
            this.cache.put(version, analyzer);
        }
        return analyzer;
    }

    public static PreBuiltAnalyzers getOrDefault(String name, PreBuiltAnalyzers defaultAnalyzer) {
        try {
            return PreBuiltAnalyzers.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return defaultAnalyzer;
        }
    }
}

