/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public final class IndicesWarmer
extends AbstractComponent {
    public static final String INDEX_WARMER_ENABLED = "index.warmer.enabled";
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final CopyOnWriteArrayList<Listener> listeners = new CopyOnWriteArrayList();

    @Inject
    public IndicesWarmer(Settings settings, ThreadPool threadPool, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void warmNewReaders(WarmerContext context) {
        this.warmInternal(context, false);
    }

    public void warmTopReader(WarmerContext context) {
        this.warmInternal(context, true);
    }

    private void warmInternal(WarmerContext context, boolean topReader) {
        IndexMetaData indexMetaData = this.clusterService.state().metaData().index(context.shardId().index().name());
        if (indexMetaData == null) {
            return;
        }
        if (!indexMetaData.settings().getAsBoolean(INDEX_WARMER_ENABLED, this.settings.getAsBoolean(INDEX_WARMER_ENABLED, (Boolean)true)).booleanValue()) {
            return;
        }
        IndexService indexService = this.indicesService.indexService(context.shardId().index().name());
        if (indexService == null) {
            return;
        }
        IndexShard indexShard = indexService.shard(context.shardId().id());
        if (indexShard == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            if (topReader) {
                this.logger.trace("[{}][{}] top warming [{}]", context.shardId().index().name(), context.shardId().id(), context);
            } else {
                this.logger.trace("[{}][{}] warming [{}]", context.shardId().index().name(), context.shardId().id(), context);
            }
        }
        indexShard.warmerService().onPreWarm();
        long time = System.nanoTime();
        ArrayList<TerminationHandle> terminationHandles = Lists.newArrayList();
        for (Listener listener : this.listeners) {
            if (topReader) {
                terminationHandles.add(listener.warmTopReader(indexShard, indexMetaData, context, this.threadPool));
                continue;
            }
            terminationHandles.add(listener.warmNewReaders(indexShard, indexMetaData, context, this.threadPool));
        }
        for (TerminationHandle terminationHandle : terminationHandles) {
            try {
                terminationHandle.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (topReader) {
                    this.logger.warn("top warming has been interrupted", e, new Object[0]);
                    break;
                }
                this.logger.warn("warming has been interrupted", e, new Object[0]);
                break;
            }
        }
        long took = System.nanoTime() - time;
        indexShard.warmerService().onPostWarm(took);
        if (indexShard.warmerService().logger().isTraceEnabled()) {
            if (topReader) {
                indexShard.warmerService().logger().trace("top warming took [{}]", new TimeValue(took, TimeUnit.NANOSECONDS));
            } else {
                indexShard.warmerService().logger().trace("warming took [{}]", new TimeValue(took, TimeUnit.NANOSECONDS));
            }
        }
    }

    public static final class WarmerContext {
        private final ShardId shardId;
        private final Engine.Searcher searcher;

        public WarmerContext(ShardId shardId, Engine.Searcher searcher) {
            this.shardId = shardId;
            this.searcher = searcher;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public Engine.Searcher searcher() {
            return this.searcher;
        }

        public IndexReader reader() {
            return this.searcher.reader();
        }

        public String toString() {
            return "WarmerContext: " + this.searcher.reader();
        }
    }

    public static abstract class Listener {
        public String executor() {
            return "warmer";
        }

        public abstract TerminationHandle warmNewReaders(IndexShard var1, IndexMetaData var2, WarmerContext var3, ThreadPool var4);

        public abstract TerminationHandle warmTopReader(IndexShard var1, IndexMetaData var2, WarmerContext var3, ThreadPool var4);
    }

    public static interface TerminationHandle {
        public static final TerminationHandle NO_WAIT = new TerminationHandle(){

            @Override
            public void awaitTermination() {
            }
        };

        public void awaitTermination() throws InterruptedException;
    }
}

