/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.InputStreamDataInput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.translog.ChecksummedTranslogStream;
import org.elasticsearch.index.translog.LegacyTranslogStream;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogStream;

public class TranslogStreams {
    public static TranslogStream LEGACY_TRANSLOG_STREAM = new LegacyTranslogStream();
    public static TranslogStream CHECKSUMMED_TRANSLOG_STREAM;
    public static TranslogStream LATEST;
    public static final String TRANSLOG_CODEC = "translog";
    private static final byte LUCENE_CODEC_HEADER_BYTE = 63;
    private static final byte UNVERSIONED_TRANSLOG_HEADER_BYTE = 0;

    static Translog.Operation newOperationFromType(Translog.Operation.Type type) throws IOException {
        switch (type) {
            case CREATE: {
                return new Translog.Create();
            }
            case DELETE: {
                return new Translog.Delete();
            }
            case DELETE_BY_QUERY: {
                return new Translog.DeleteByQuery();
            }
            case SAVE: {
                return new Translog.Index();
            }
        }
        throw new IOException("No type for [" + (Object)((Object)type) + "]");
    }

    public static Translog.Operation readTranslogOperation(StreamInput in) throws IOException {
        return LATEST.read(in);
    }

    public static void writeTranslogOperation(StreamOutput out, Translog.Operation op) throws IOException {
        LATEST.write(out, op);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TranslogStream translogStreamFor(File translogFile) throws IOException {
        try (InputStreamStreamInput headerStream = new InputStreamStreamInput(new FileInputStream(translogFile));){
            if (!translogFile.exists() || translogFile.length() == 0L) {
                TranslogStream translogStream = CHECKSUMMED_TRANSLOG_STREAM;
                return translogStream;
            }
            byte b1 = headerStream.readByte();
            if (b1 == 63) {
                byte b4;
                byte b3;
                byte b2 = headerStream.readByte();
                int header = ((b1 & 0xFF) << 24) + ((b2 & 0xFF) << 16) + (((b3 = headerStream.readByte()) & 0xFF) << 8) + (((b4 = headerStream.readByte()) & 0xFF) << 0);
                if (header != 1071082519) {
                    throw new TranslogCorruptedException("translog looks like version 1 or later, but has corrupted header");
                }
                int version = CodecUtil.checkHeaderNoMagic(new InputStreamDataInput(headerStream), TRANSLOG_CODEC, 1, Integer.MAX_VALUE);
                switch (version) {
                    case 1: {
                        TranslogStream translogStream = CHECKSUMMED_TRANSLOG_STREAM;
                        return translogStream;
                    }
                }
                throw new TranslogCorruptedException("No known translog stream version: " + version);
            }
            if (b1 == 0) {
                TranslogStream translogStream = LEGACY_TRANSLOG_STREAM;
                return translogStream;
            }
            throw new TranslogCorruptedException("Invalid first byte in translog file, got: " + Long.toHexString(b1) + ", expected 0x00 or 0x3f");
        }
        catch (CorruptIndexException e) {
            throw new TranslogCorruptedException("Translog header corrupted", e);
        }
    }

    static {
        LATEST = CHECKSUMMED_TRANSLOG_STREAM = new ChecksummedTranslogStream();
    }
}

