/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.InputStreamDataInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NoopStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.index.translog.BufferedChecksumStreamOutput;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.index.translog.TranslogCorruptedException;
import org.elasticsearch.index.translog.TranslogStream;
import org.elasticsearch.index.translog.TranslogStreams;
import org.elasticsearch.index.translog.TruncatedTranslogException;

public class ChecksummedTranslogStream
implements TranslogStream {
    public static final int VERSION = 1;

    ChecksummedTranslogStream() {
    }

    private void verifyChecksum(BufferedChecksumStreamInput in) throws IOException {
        long expectedChecksum = in.getChecksum();
        long readChecksum = (long)in.readInt() & 0xFFFFFFFFL;
        if (readChecksum != expectedChecksum) {
            throw new TranslogCorruptedException("translog stream is corrupted, expected: 0x" + Long.toHexString(expectedChecksum) + ", got: 0x" + Long.toHexString(readChecksum));
        }
    }

    @Override
    public Translog.Operation read(StreamInput inStream) throws IOException {
        Translog.Operation operation;
        int opSize = inStream.readInt();
        BufferedChecksumStreamInput in = new BufferedChecksumStreamInput(inStream);
        try {
            Translog.Operation.Type type = Translog.Operation.Type.fromId(in.readByte());
            operation = TranslogStreams.newOperationFromType(type);
            operation.readFrom(in);
        }
        catch (EOFException e) {
            throw new TruncatedTranslogException("reached premature end of file, translog is truncated", e);
        }
        catch (AssertionError | Exception e) {
            throw new TranslogCorruptedException("translog corruption while reading from stream", (Throwable)e);
        }
        this.verifyChecksum(in);
        return operation;
    }

    @Override
    public void write(StreamOutput outStream, Translog.Operation op) throws IOException {
        NoopStreamOutput noopOut = new NoopStreamOutput();
        noopOut.writeByte(op.opType().id());
        op.writeTo(noopOut);
        noopOut.writeInt(0);
        int size = noopOut.getCount();
        BufferedChecksumStreamOutput out = new BufferedChecksumStreamOutput(outStream);
        outStream.writeInt(size);
        out.writeByte(op.opType().id());
        op.writeTo(out);
        long checksum = out.getChecksum();
        out.writeInt((int)checksum);
    }

    @Override
    public int writeHeader(FileChannel channel) throws IOException {
        OutputStreamDataOutput out = new OutputStreamDataOutput(Channels.newOutputStream(channel));
        CodecUtil.writeHeader(out, "translog", 1);
        return CodecUtil.headerLength("translog");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StreamInput openInput(File translogFile) throws IOException {
        InputStreamStreamInput inputStreamStreamInput;
        block6: {
            FileInputStream fileInputStream = new FileInputStream(translogFile);
            boolean success = false;
            try {
                InputStreamStreamInput in = new InputStreamStreamInput(fileInputStream);
                CodecUtil.checkHeader(new InputStreamDataInput(in), "translog", 1, 1);
                success = true;
                inputStreamStreamInput = in;
                if (success) break block6;
            }
            catch (EOFException e) {
                try {
                    throw new TruncatedTranslogException("translog header truncated", e);
                    catch (IOException e2) {
                        throw new TranslogCorruptedException("translog header corrupted", e2);
                    }
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(fileInputStream);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(fileInputStream);
        }
        return inputStreamStreamInput;
    }
}

