/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.BufferedChecksum;
import org.elasticsearch.common.io.stream.StreamInput;

public final class BufferedChecksumStreamInput
extends StreamInput {
    private final StreamInput in;
    private final Checksum digest;

    public BufferedChecksumStreamInput(StreamInput in) {
        this.in = in;
        this.digest = new BufferedChecksum(new CRC32());
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.in.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
        this.digest.reset();
    }

    @Override
    public int read() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

