/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.termvectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.memory.MemoryIndex;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.Versions;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.get.GetField;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.ParsedDocument;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;

public class ShardTermVectorService
extends AbstractIndexShardComponent {
    private IndexShard indexShard;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public ShardTermVectorService(ShardId shardId, @IndexSettings Settings indexSettings, MappingUpdatedAction mappingUpdatedAction) {
        super(shardId, indexSettings);
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    public ShardTermVectorService setIndexShard(IndexShard indexShard) {
        this.indexShard = indexShard;
        return this;
    }

    public TermVectorResponse getTermVector(TermVectorRequest request, String concreteIndex) {
        boolean docFromTranslog;
        Engine.Searcher searcher = this.indexShard.acquireSearcher("term_vector");
        IndexReader topLevelReader = searcher.reader();
        TermVectorResponse termVectorResponse = new TermVectorResponse(concreteIndex, request.type(), request.id());
        Term uidTerm = new Term("_uid", Uid.createUidAsBytes(request.type(), request.id()));
        Engine.GetResult get = this.indexShard.get(new Engine.Get(request.realtime(), uidTerm));
        boolean bl = docFromTranslog = get.source() != null;
        if (docFromTranslog) {
            request.doc(get.source().source, false);
            termVectorResponse.setDocVersion(get.version());
        }
        if (request.selectedFields() != null) {
            this.handleFieldWildcards(request);
        }
        try {
            Fields topLevelFields = MultiFields.getFields(topLevelReader);
            Versions.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
            if (request.doc() != null) {
                Fields termVectorsByField = this.generateTermVectorsFromDoc(request, !docFromTranslog);
                if (topLevelFields == null) {
                    topLevelFields = termVectorsByField;
                }
                termVectorResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields);
                termVectorResponse.setExists(true);
                termVectorResponse.setArtificial(!docFromTranslog);
            } else if (docIdAndVersion != null) {
                Fields termVectorsByField = docIdAndVersion.context.reader().getTermVectors(docIdAndVersion.docId);
                Set<String> selectedFields = request.selectedFields();
                if (selectedFields == null && request.perFieldAnalyzer() != null) {
                    selectedFields = this.getFieldsToGenerate(request.perFieldAnalyzer(), termVectorsByField);
                }
                if (selectedFields != null) {
                    termVectorsByField = this.addGeneratedTermVectors(get, termVectorsByField, request, selectedFields);
                }
                termVectorResponse.setFields(termVectorsByField, request.selectedFields(), request.getFlags(), topLevelFields);
                termVectorResponse.setDocVersion(docIdAndVersion.version);
                termVectorResponse.setExists(true);
            } else {
                termVectorResponse.setExists(false);
            }
        }
        catch (Throwable ex) {
            throw new ElasticsearchException("failed to execute term vector request", ex);
        }
        finally {
            searcher.close();
            get.release();
        }
        return termVectorResponse;
    }

    private void handleFieldWildcards(TermVectorRequest request) {
        HashSet<String> fieldNames = new HashSet<String>();
        for (String pattern : request.selectedFields()) {
            fieldNames.addAll(this.indexShard.mapperService().simpleMatchToIndexNames(pattern));
        }
        request.selectedFields(fieldNames.toArray(Strings.EMPTY_ARRAY));
    }

    private boolean isValidField(FieldMapper field) {
        if (!(field instanceof StringFieldMapper)) {
            return false;
        }
        return field.fieldType().indexed();
    }

    private Fields addGeneratedTermVectors(Engine.GetResult get, Fields termVectorsByField, TermVectorRequest request, Set<String> selectedFields) throws IOException {
        HashSet<String> validFields = new HashSet<String>();
        for (String field : selectedFields) {
            FieldMapper fieldMapper = this.indexShard.mapperService().smartNameFieldMapper(field);
            if (!this.isValidField(fieldMapper) || fieldMapper.fieldType().storeTermVectors() && (request.perFieldAnalyzer() == null || !request.perFieldAnalyzer().containsKey(field))) continue;
            validFields.add(field);
        }
        if (validFields.isEmpty()) {
            return termVectorsByField;
        }
        GetResult getResult = this.indexShard.getService().get(get, request.id(), request.type(), validFields.toArray(Strings.EMPTY_ARRAY), null, false);
        Fields generatedTermVectors = this.generateTermVectors(getResult.getFields().values(), request.offsets(), request.perFieldAnalyzer());
        if (termVectorsByField == null) {
            return generatedTermVectors;
        }
        return this.mergeFields(termVectorsByField, generatedTermVectors);
    }

    private Analyzer getAnalyzerAtField(String field, @Nullable Map<String, String> perFieldAnalyzer) {
        MapperService mapperService = this.indexShard.mapperService();
        Analyzer analyzer = perFieldAnalyzer != null && perFieldAnalyzer.containsKey(field) ? mapperService.analysisService().analyzer(perFieldAnalyzer.get(field).toString()) : mapperService.smartNameFieldMapper(field).indexAnalyzer();
        if (analyzer == null) {
            analyzer = mapperService.analysisService().defaultIndexAnalyzer();
        }
        return analyzer;
    }

    private Set<String> getFieldsToGenerate(Map<String, String> perAnalyzerField, Fields fieldsObject) {
        HashSet<String> selectedFields = new HashSet<String>();
        for (String fieldName : fieldsObject) {
            if (!perAnalyzerField.containsKey(fieldName)) continue;
            selectedFields.add(fieldName);
        }
        return selectedFields;
    }

    private Fields generateTermVectors(Collection<GetField> getFields, boolean withOffsets, @Nullable Map<String, String> perFieldAnalyzer) throws IOException {
        MemoryIndex index = new MemoryIndex(withOffsets);
        for (GetField getField : getFields) {
            String field = getField.getName();
            Analyzer analyzer = this.getAnalyzerAtField(field, perFieldAnalyzer);
            for (Object text : getField.getValues()) {
                index.addField(field, text.toString(), analyzer);
            }
        }
        return MultiFields.getFields(index.createSearcher().getIndexReader());
    }

    private Fields generateTermVectorsFromDoc(TermVectorRequest request, boolean doAllFields) throws IOException {
        ParsedDocument parsedDocument = this.parseDocument(this.indexShard.shardId().getIndex(), request.type(), request.doc());
        ParseContext.Document doc = parsedDocument.rootDoc();
        HashSet<String> seenFields = new HashSet<String>();
        HashSet<GetField> getFields = new HashSet<GetField>();
        for (IndexableField field : doc.getFields()) {
            FieldMapper fieldMapper = this.indexShard.mapperService().smartNameFieldMapper(field.name());
            if (seenFields.contains(field.name())) continue;
            seenFields.add(field.name());
            if (!this.isValidField(fieldMapper) || request.selectedFields() == null && !doAllFields && !fieldMapper.fieldType().storeTermVectors() || request.selectedFields() != null && !request.selectedFields().contains(field.name())) continue;
            String[] values = doc.getValues(field.name());
            getFields.add(new GetField(field.name(), Arrays.asList((Object[])values)));
        }
        return this.generateTermVectors(getFields, request.offsets(), request.perFieldAnalyzer());
    }

    private ParsedDocument parseDocument(String index, String type, BytesReference doc) {
        MapperService mapperService = this.indexShard.mapperService();
        IndexService indexService = this.indexShard.indexService();
        Tuple<DocumentMapper, Boolean> docMapper = mapperService.documentMapperWithAutoCreate(type);
        ParsedDocument parsedDocument = docMapper.v1().parse(SourceToParse.source(doc).type(type).flyweight(true)).setMappingsModified(docMapper);
        if (parsedDocument.mappingsModified()) {
            this.mappingUpdatedAction.updateMappingOnMaster(index, docMapper.v1(), indexService.indexUUID());
        }
        return parsedDocument;
    }

    private Fields mergeFields(Fields fields1, Fields fields2) throws IOException {
        Terms terms;
        ParallelFields parallelFields = new ParallelFields();
        for (String fieldName : fields2) {
            terms = fields2.terms(fieldName);
            if (terms == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        for (String fieldName : fields1) {
            if (parallelFields.fields.containsKey(fieldName) || (terms = fields1.terms(fieldName)) == null) continue;
            parallelFields.addField(fieldName, terms);
        }
        return parallelFields;
    }

    private static final class ParallelFields
    extends Fields {
        final Map<String, Terms> fields = new TreeMap<String, Terms>();

        ParallelFields() {
        }

        void addField(String fieldName, Terms terms) {
            this.fields.put(fieldName, terms);
        }

        @Override
        public Iterator<String> iterator() {
            return Collections.unmodifiableSet(this.fields.keySet()).iterator();
        }

        @Override
        public Terms terms(String field) {
            return this.fields.get(field);
        }

        @Override
        public int size() {
            return this.fields.size();
        }
    }
}

