/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.distributor;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.store.DirectoryService;
import org.elasticsearch.index.store.distributor.AbstractDistributor;

public class LeastUsedDistributor
extends AbstractDistributor {
    @Inject
    public LeastUsedDistributor(DirectoryService directoryService) throws IOException {
        super(directoryService);
    }

    @Override
    public Directory doAny() {
        Directory directory = null;
        long size = Long.MIN_VALUE;
        int sameSize = 0;
        for (Directory delegate : this.delegates) {
            long currentSize = this.getUsableSpace(delegate);
            if (currentSize > size) {
                size = currentSize;
                directory = delegate;
                sameSize = 1;
                continue;
            }
            if (currentSize != size) continue;
            ++sameSize;
            if (!(ThreadLocalRandom.current().nextDouble() < 1.0 / (double)sameSize)) continue;
            directory = delegate;
        }
        return directory;
    }

    @Override
    public String name() {
        return "least_used";
    }
}

